CREATE TABLE `rv_region` (
  `id` int(11) NOT NULL,
  `country_code` varchar(2) NOT NULL,
  `subdivision_name` varchar(44) NOT NULL,
  `code` varchar(6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;


INSERT INTO `rv_region` (`id`, `country_code`, `subdivision_name`, `code`) VALUES
(1, 'AD', 'Andorra la Vella', 'AD-07'),
(2, 'AD', 'Canillo', 'AD-02'),
(3, 'AD', 'Encamp', 'AD-03'),
(4, 'AD', 'Escaldes-Engordany', 'AD-08'),
(5, 'AD', 'La Massana', 'AD-04'),
(6, 'AD', 'Ordino', 'AD-05'),
(7, 'AD', 'Sant Julia de Loria', 'AD-06'),
(8, 'AE', 'Ajman', 'AE-AJ'),
(9, 'AE', 'Abu Zaby', 'AE-AZ'),
(10, 'AE', 'Al Fujayrah', 'AE-FU'),
(11, 'AE', 'Ash Shariqah', 'AE-SH'),
(12, 'AE', 'Dubayy', 'AE-DU'),
(13, 'AE', 'Ras al Khaymah', 'AE-RK'),
(14, 'AE', 'Umm al Qaywayn', 'AE-UQ'),
(15, 'AF', 'Badakhshan', 'AF-BDS'),
(16, 'AF', 'Badghis', 'AF-BDG'),
(17, 'AF', 'Baghlan', 'AF-BGL'),
(18, 'AF', 'Balkh', 'AF-BAL'),
(19, 'AF', 'Bamyan', 'AF-BAM'),
(20, 'AF', 'Daykundi', 'AF-DAY'),
(21, 'AF', 'Farah', 'AF-FRA'),
(22, 'AF', 'Faryab', 'AF-FYB'),
(23, 'AF', 'Ghazni', 'AF-GHA'),
(24, 'AF', 'Ghor', 'AF-GHO'),
(25, 'AF', 'Helmand', 'AF-HEL'),
(26, 'AF', 'Herat', 'AF-HER'),
(27, 'AF', 'Jowzjan', 'AF-JOW'),
(28, 'AF', 'Kabul', 'AF-KAB'),
(29, 'AF', 'Kandahar', 'AF-KAN'),
(30, 'AF', 'Khost', 'AF-KHO'),
(31, 'AF', 'Kunduz', 'AF-KDZ'),
(32, 'AF', 'Laghman', 'AF-LAG'),
(33, 'AF', 'Logar', 'AF-LOG'),
(34, 'AF', 'Nangarhar', 'AF-NAN'),
(35, 'AF', 'Nimroz', 'AF-NIM'),
(36, 'AF', 'Paktika', 'AF-PKA'),
(37, 'AF', 'Paktiya', 'AF-PIA'),
(38, 'AF', 'Parwan', 'AF-PAR'),
(39, 'AF', 'Takhar', 'AF-TAK'),
(40, 'AF', 'Uruzgan', 'AF-URU'),
(41, 'AG', 'Redonda', 'AG-11'),
(42, 'AG', 'Saint George', 'AG-03'),
(43, 'AG', 'Saint John', 'AG-04'),
(44, 'AG', 'Saint Mary', 'AG-05'),
(45, 'AG', 'Saint Paul', 'AG-06'),
(46, 'AG', 'Saint Peter', 'AG-07'),
(47, 'AG', 'Saint Philip', 'AG-08'),
(48, 'AI', 'Anguilla', '-'),
(49, 'AL', 'Berat', 'AL-01'),
(50, 'AL', 'Diber', 'AL-09'),
(51, 'AL', 'Durres', 'AL-02'),
(52, 'AL', 'Elbasan', 'AL-03'),
(53, 'AL', 'Fier', 'AL-04'),
(54, 'AL', 'Gjirokaster', 'AL-05'),
(55, 'AL', 'Korce', 'AL-06'),
(56, 'AL', 'Kukes', 'AL-07'),
(57, 'AL', 'Lezhe', 'AL-08'),
(58, 'AL', 'Shkoder', 'AL-10'),
(59, 'AL', 'Tirane', 'AL-11'),
(60, 'AL', 'Vlore', 'AL-12'),
(61, 'AM', 'Aragacotn', 'AM-AG'),
(62, 'AM', 'Ararat', 'AM-AR'),
(63, 'AM', 'Armavir', 'AM-AV'),
(64, 'AM', 'Erevan', 'AM-ER'),
(65, 'AM', 'Gegarkunik', 'AM-GR'),
(66, 'AM', 'Kotayk', 'AM-KT'),
(67, 'AM', 'Lori', 'AM-LO'),
(68, 'AM', 'Sirak', 'AM-SH'),
(69, 'AM', 'Syunik', 'AM-SU'),
(70, 'AM', 'Tavus', 'AM-TV'),
(71, 'AM', 'Vayoc Jor', 'AM-VD'),
(72, 'AO', 'Bengo', 'AO-BGO'),
(73, 'AO', 'Benguela', 'AO-BGU'),
(74, 'AO', 'Bie', 'AO-BIE'),
(75, 'AO', 'Cabinda', 'AO-CAB'),
(76, 'AO', 'Cuando Cubango', 'AO-CCU'),
(77, 'AO', 'Cuanza-Norte', 'AO-CNO'),
(78, 'AO', 'Cuanza-Sul', 'AO-CUS'),
(79, 'AO', 'Cunene', 'AO-CNN'),
(80, 'AO', 'Huambo', 'AO-HUA'),
(81, 'AO', 'Huila', 'AO-HUI'),
(82, 'AO', 'Luanda', 'AO-LUA'),
(83, 'AO', 'Lunda-Norte', 'AO-LNO'),
(84, 'AO', 'Lunda-Sul', 'AO-LSU'),
(85, 'AO', 'Malange', 'AO-MAL'),
(86, 'AO', 'Moxico', 'AO-MOX'),
(87, 'AO', 'Namibe', 'AO-NAM'),
(88, 'AO', 'Uige', 'AO-UIG'),
(89, 'AO', 'Zaire', 'AO-ZAI'),
(90, 'AR', 'Buenos Aires', 'AR-B'),
(91, 'AR', 'Catamarca', 'AR-K'),
(92, 'AR', 'Chaco', 'AR-H'),
(93, 'AR', 'Chubut', 'AR-U'),
(94, 'AR', 'Ciudad Autonoma de Buenos Aires', 'AR-C'),
(95, 'AR', 'Cordoba', 'AR-X'),
(96, 'AR', 'Corrientes', 'AR-W'),
(97, 'AR', 'Entre Rios', 'AR-E'),
(98, 'AR', 'Formosa', 'AR-P'),
(99, 'AR', 'Jujuy', 'AR-Y'),
(100, 'AR', 'La Pampa', 'AR-L'),
(101, 'AR', 'La Rioja', 'AR-F'),
(102, 'AR', 'Mendoza', 'AR-M'),
(103, 'AR', 'Misiones', 'AR-N'),
(104, 'AR', 'Neuquen', 'AR-Q'),
(105, 'AR', 'Rio Negro', 'AR-R'),
(106, 'AR', 'Salta', 'AR-A'),
(107, 'AR', 'San Juan', 'AR-J'),
(108, 'AR', 'San Luis', 'AR-D'),
(109, 'AR', 'Santa Cruz', 'AR-Z'),
(110, 'AR', 'Santa Fe', 'AR-S'),
(111, 'AR', 'Santiago del Estero', 'AR-G'),
(112, 'AR', 'Tierra del Fuego', 'AR-V'),
(113, 'AR', 'Tucuman', 'AR-T'),
(114, 'AS', 'Eastern District', '-'),
(115, 'AS', 'Western District', '-'),
(116, 'AT', 'Burgenland', 'AT-1'),
(117, 'AT', 'Karnten', 'AT-2'),
(118, 'AT', 'Niederosterreich', 'AT-3'),
(119, 'AT', 'Oberosterreich', 'AT-4'),
(120, 'AT', 'Salzburg', 'AT-5'),
(121, 'AT', 'Steiermark', 'AT-6'),
(122, 'AT', 'Tirol', 'AT-7'),
(123, 'AT', 'Vorarlberg', 'AT-8'),
(124, 'AT', 'Wien', 'AT-9'),
(125, 'AU', 'Australian Capital Territory', 'AU-ACT'),
(126, 'AU', 'New South Wales', 'AU-NSW'),
(127, 'AU', 'Northern Territory', 'AU-NT'),
(128, 'AU', 'Queensland', 'AU-QLD'),
(129, 'AU', 'South Australia', 'AU-SA'),
(130, 'AU', 'Tasmania', 'AU-TAS'),
(131, 'AU', 'Victoria', 'AU-VIC'),
(132, 'AU', 'Western Australia', 'AU-WA'),
(133, 'AW', 'Aruba', '-'),
(134, 'AX', 'Eckeroe', '-'),
(135, 'AX', 'Finstroem', '-'),
(136, 'AX', 'Hammarland', '-'),
(137, 'AX', 'Jomala', '-'),
(138, 'AX', 'Lemland', '-'),
(139, 'AX', 'Mariehamn', '-'),
(140, 'AX', 'Saltvik', '-'),
(141, 'AX', 'Sund', '-'),
(142, 'AZ', 'Abseron', 'AZ-ABS'),
(143, 'AZ', 'Agcabadi', 'AZ-AGC'),
(144, 'AZ', 'Agdas', 'AZ-AGS'),
(145, 'AZ', 'Astara', 'AZ-AST'),
(146, 'AZ', 'Baki', 'AZ-BA'),
(147, 'AZ', 'Balakan', 'AZ-BAL'),
(148, 'AZ', 'Barda', 'AZ-BAR'),
(149, 'AZ', 'Beylaqan', 'AZ-BEY'),
(150, 'AZ', 'Bilasuvar', 'AZ-BIL'),
(151, 'AZ', 'Calilabad', 'AZ-CAL'),
(152, 'AZ', 'Fuzuli', 'AZ-FUZ'),
(153, 'AZ', 'Gadabay', 'AZ-GAD'),
(154, 'AZ', 'Ganca', 'AZ-GA'),
(155, 'AZ', 'Goranboy', 'AZ-GOR'),
(156, 'AZ', 'Goycay', 'AZ-GOY'),
(157, 'AZ', 'Goygol', 'AZ-GYG'),
(158, 'AZ', 'Imisli', 'AZ-IMI'),
(159, 'AZ', 'Ismayilli', 'AZ-ISM'),
(160, 'AZ', 'Kurdamir', 'AZ-KUR'),
(161, 'AZ', 'Lankaran', 'AZ-LA'),
(162, 'AZ', 'Masalli', 'AZ-MAS'),
(163, 'AZ', 'Mingacevir', 'AZ-MI'),
(164, 'AZ', 'Naxcivan', 'AZ-NX'),
(165, 'AZ', 'Neftcala', 'AZ-NEF'),
(166, 'AZ', 'Oguz', 'AZ-OGU'),
(167, 'AZ', 'Qabala', 'AZ-QAB'),
(168, 'AZ', 'Qax', 'AZ-QAX'),
(169, 'AZ', 'Quba', 'AZ-QBA'),
(170, 'AZ', 'Qusar', 'AZ-QUS'),
(171, 'AZ', 'Saatli', 'AZ-SAT'),
(172, 'AZ', 'Sabirabad', 'AZ-SAB'),
(173, 'AZ', 'Saki', 'AZ-SAK'),
(174, 'AZ', 'Salyan', 'AZ-SAL'),
(175, 'AZ', 'Samaxi', 'AZ-SMI'),
(176, 'AZ', 'Samkir', 'AZ-SKR'),
(177, 'AZ', 'Samux', 'AZ-SMX'),
(178, 'AZ', 'Sirvan', 'AZ-SR'),
(179, 'AZ', 'Siyazan', 'AZ-SIY'),
(180, 'AZ', 'Sumqayit', 'AZ-SM'),
(181, 'AZ', 'Tartar', 'AZ-TAR'),
(182, 'AZ', 'Xacmaz', 'AZ-XAC'),
(183, 'AZ', 'Xizi', 'AZ-XIZ'),
(184, 'AZ', 'Yardimli', 'AZ-YAR'),
(185, 'AZ', 'Yevlax', 'AZ-YEV'),
(186, 'AZ', 'Zaqatala', 'AZ-ZAQ'),
(187, 'AZ', 'Zardab', 'AZ-ZAR'),
(188, 'BA', 'Brcko distrikt', 'BA-BRC'),
(189, 'BA', 'Federacija Bosne i Hercegovine', 'BA-BIH'),
(190, 'BA', 'Republika Srpska', 'BA-SRP'),
(191, 'BB', 'Christ Church', 'BB-01'),
(192, 'BB', 'Saint Andrew', 'BB-02'),
(193, 'BB', 'Saint George', 'BB-03'),
(194, 'BB', 'Saint James', 'BB-04'),
(195, 'BB', 'Saint John', 'BB-05'),
(196, 'BB', 'Saint Lucy', 'BB-07'),
(197, 'BB', 'Saint Michael', 'BB-08'),
(198, 'BB', 'Saint Peter', 'BB-09'),
(199, 'BB', 'Saint Philip', 'BB-10'),
(200, 'BB', 'Saint Thomas', 'BB-11'),
(201, 'BD', 'Barishal', 'BD-A'),
(202, 'BD', 'Chattogram', 'BD-B'),
(203, 'BD', 'Dhaka', 'BD-C'),
(204, 'BD', 'Khulna', 'BD-D'),
(205, 'BD', 'Rajshahi', 'BD-E'),
(206, 'BD', 'Rangpur', 'BD-F'),
(207, 'BD', 'Sylhet', 'BD-G'),
(208, 'BE', 'Antwerpen', 'BE-VAN'),
(209, 'BE', 'Brabant wallon', 'BE-WBR'),
(210, 'BE', 'Brussels Hoofdstedelijk Gewest', 'BE-BRU'),
(211, 'BE', 'Hainaut', 'BE-WHT'),
(212, 'BE', 'Liege', 'BE-WLG'),
(213, 'BE', 'Limburg', 'BE-VLI'),
(214, 'BE', 'Luxembourg', 'BE-WLX'),
(215, 'BE', 'Namur', 'BE-WNA'),
(216, 'BE', 'Oost-Vlaanderen', 'BE-VOV'),
(217, 'BE', 'Vlaams-Brabant', 'BE-VBR'),
(218, 'BE', 'West-Vlaanderen', 'BE-VWV'),
(219, 'BF', 'Bam', 'BF-BAM'),
(220, 'BF', 'Bazega', 'BF-BAZ'),
(221, 'BF', 'Boulgou', 'BF-BLG'),
(222, 'BF', 'Boulkiemde', 'BF-BLK'),
(223, 'BF', 'Ganzourgou', 'BF-GAN'),
(224, 'BF', 'Gnagna', 'BF-GNA'),
(225, 'BF', 'Gourma', 'BF-GOU'),
(226, 'BF', 'Houet', 'BF-HOU'),
(227, 'BF', 'Kadiogo', 'BF-KAD'),
(228, 'BF', 'Komondjari', 'BF-KMD'),
(229, 'BF', 'Kompienga', 'BF-KMP'),
(230, 'BF', 'Koulpelogo', 'BF-KOP'),
(231, 'BF', 'Kouritenga', 'BF-KOT'),
(232, 'BF', 'Kourweogo', 'BF-KOW'),
(233, 'BF', 'Leraba', 'BF-LER'),
(234, 'BF', 'Loroum', 'BF-LOR'),
(235, 'BF', 'Nahouri', 'BF-NAO'),
(236, 'BF', 'Namentenga', 'BF-NAM'),
(237, 'BF', 'Nayala', 'BF-NAY'),
(238, 'BF', 'Oubritenga', 'BF-OUB'),
(239, 'BF', 'Oudalan', 'BF-OUD'),
(240, 'BF', 'Passore', 'BF-PAS'),
(241, 'BF', 'Poni', 'BF-PON'),
(242, 'BF', 'Sanmatenga', 'BF-SMT'),
(243, 'BF', 'Seno', 'BF-SEN'),
(244, 'BF', 'Sissili', 'BF-SIS'),
(245, 'BF', 'Soum', 'BF-SOM'),
(246, 'BF', 'Sourou', 'BF-SOR'),
(247, 'BF', 'Tapoa', 'BF-TAP'),
(248, 'BF', 'Tuy', 'BF-TUI'),
(249, 'BF', 'Yatenga', 'BF-YAT'),
(250, 'BF', 'Ziro', 'BF-ZIR'),
(251, 'BF', 'Zondoma', 'BF-ZON'),
(252, 'BF', 'Zoundweogo', 'BF-ZOU'),
(253, 'BG', 'Blagoevgrad', 'BG-01'),
(254, 'BG', 'Burgas', 'BG-02'),
(255, 'BG', 'Dobrich', 'BG-08'),
(256, 'BG', 'Gabrovo', 'BG-07'),
(257, 'BG', 'Haskovo', 'BG-26'),
(258, 'BG', 'Kardzhali', 'BG-09'),
(259, 'BG', 'Kyustendil', 'BG-10'),
(260, 'BG', 'Lovech', 'BG-11'),
(261, 'BG', 'Montana', 'BG-12'),
(262, 'BG', 'Pazardzhik', 'BG-13'),
(263, 'BG', 'Pernik', 'BG-14'),
(264, 'BG', 'Pleven', 'BG-15'),
(265, 'BG', 'Plovdiv', 'BG-16'),
(266, 'BG', 'Razgrad', 'BG-17'),
(267, 'BG', 'Ruse', 'BG-18'),
(268, 'BG', 'Shumen', 'BG-27'),
(269, 'BG', 'Silistra', 'BG-19'),
(270, 'BG', 'Sliven', 'BG-20'),
(271, 'BG', 'Smolyan', 'BG-21'),
(272, 'BG', 'Sofia', 'BG-23'),
(273, 'BG', 'Sofia (stolitsa)', 'BG-22'),
(274, 'BG', 'Stara Zagora', 'BG-24'),
(275, 'BG', 'Targovishte', 'BG-25'),
(276, 'BG', 'Varna', 'BG-03'),
(277, 'BG', 'Veliko Tarnovo', 'BG-04'),
(278, 'BG', 'Vidin', 'BG-05'),
(279, 'BG', 'Vratsa', 'BG-06'),
(280, 'BG', 'Yambol', 'BG-28'),
(281, 'BH', 'Al Asimah', 'BH-13'),
(282, 'BH', 'Al Janubiyah', 'BH-14'),
(283, 'BH', 'Al Muharraq', 'BH-15'),
(284, 'BH', 'Ash Shamaliyah', 'BH-17'),
(285, 'BI', 'Bujumbura Mairie', 'BI-BM'),
(286, 'BI', 'Cibitoke', 'BI-CI'),
(287, 'BI', 'Gitega', 'BI-GI'),
(288, 'BI', 'Kirundo', 'BI-KI'),
(289, 'BI', 'Mwaro', 'BI-MW'),
(290, 'BI', 'Ngozi', 'BI-NG'),
(291, 'BI', 'Rumonge', 'BI-RM'),
(292, 'BI', 'Rutana', 'BI-RT'),
(293, 'BI', 'Ruyigi', 'BI-RY'),
(294, 'BJ', 'Alibori', 'BJ-AL'),
(295, 'BJ', 'Atacora', 'BJ-AK'),
(296, 'BJ', 'Atlantique', 'BJ-AQ'),
(297, 'BJ', 'Borgou', 'BJ-BO'),
(298, 'BJ', 'Donga', 'BJ-DO'),
(299, 'BJ', 'Littoral', 'BJ-LI'),
(300, 'BJ', 'Mono', 'BJ-MO'),
(301, 'BJ', 'Oueme', 'BJ-OU'),
(302, 'BJ', 'Plateau', 'BJ-PL'),
(303, 'BJ', 'Zou', 'BJ-ZO'),
(304, 'BL', 'Saint Barthelemy', '-'),
(305, 'BM', 'Hamilton', '-'),
(306, 'BM', 'Saint George', '-'),
(307, 'BN', 'Belait', 'BN-BE'),
(308, 'BN', 'Brunei-Muara', 'BN-BM'),
(309, 'BN', 'Temburong', 'BN-TE'),
(310, 'BN', 'Tutong', 'BN-TU'),
(311, 'BO', 'Chuquisaca', 'BO-H'),
(312, 'BO', 'Cochabamba', 'BO-C'),
(313, 'BO', 'El Beni', 'BO-B'),
(314, 'BO', 'La Paz', 'BO-L'),
(315, 'BO', 'Oruro', 'BO-O'),
(316, 'BO', 'Pando', 'BO-N'),
(317, 'BO', 'Potosi', 'BO-P'),
(318, 'BO', 'Santa Cruz', 'BO-S'),
(319, 'BO', 'Tarija', 'BO-T'),
(320, 'BQ', 'Bonaire', 'BQ-BO'),
(321, 'BQ', 'Saba', 'BQ-SA'),
(322, 'BQ', 'Sint Eustatius', 'BQ-SE'),
(323, 'BR', 'Acre', 'BR-AC'),
(324, 'BR', 'Alagoas', 'BR-AL'),
(325, 'BR', 'Amapa', 'BR-AP'),
(326, 'BR', 'Amazonas', 'BR-AM'),
(327, 'BR', 'Bahia', 'BR-BA'),
(328, 'BR', 'Ceara', 'BR-CE'),
(329, 'BR', 'Distrito Federal', 'BR-DF'),
(330, 'BR', 'Espirito Santo', 'BR-ES'),
(331, 'BR', 'Goias', 'BR-GO'),
(332, 'BR', 'Maranhao', 'BR-MA'),
(333, 'BR', 'Mato Grosso', 'BR-MT'),
(334, 'BR', 'Mato Grosso do Sul', 'BR-MS'),
(335, 'BR', 'Minas Gerais', 'BR-MG'),
(336, 'BR', 'Para', 'BR-PA'),
(337, 'BR', 'Paraiba', 'BR-PB'),
(338, 'BR', 'Parana', 'BR-PR'),
(339, 'BR', 'Pernambuco', 'BR-PE'),
(340, 'BR', 'Piaui', 'BR-PI'),
(341, 'BR', 'Rio Grande do Norte', 'BR-RN'),
(342, 'BR', 'Rio Grande do Sul', 'BR-RS'),
(343, 'BR', 'Rio de Janeiro', 'BR-RJ'),
(344, 'BR', 'Rondonia', 'BR-RO'),
(345, 'BR', 'Roraima', 'BR-RR'),
(346, 'BR', 'Santa Catarina', 'BR-SC'),
(347, 'BR', 'Sao Paulo', 'BR-SP'),
(348, 'BR', 'Sergipe', 'BR-SE'),
(349, 'BR', 'Tocantins', 'BR-TO'),
(350, 'BS', 'Central Abaco', 'BS-CO'),
(351, 'BS', 'City of Freeport', 'BS-FP'),
(352, 'BS', 'Long Island', 'BS-LI'),
(353, 'BS', 'New Providence', 'BS-NP'),
(354, 'BS', 'North Abaco', 'BS-NO'),
(355, 'BS', 'North Andros', 'BS-NS'),
(356, 'BS', 'South Eleuthera', 'BS-SE'),
(357, 'BT', 'Bumthang', 'BT-33'),
(358, 'BT', 'Chhukha', 'BT-12'),
(359, 'BT', 'Gasa', 'BT-GA'),
(360, 'BT', 'Haa', 'BT-13'),
(361, 'BT', 'Lhuentse', 'BT-44'),
(362, 'BT', 'Monggar', 'BT-42'),
(363, 'BT', 'Paro', 'BT-11'),
(364, 'BT', 'Pema Gatshel', 'BT-43'),
(365, 'BT', 'Punakha', 'BT-23'),
(366, 'BT', 'Samdrup Jongkhar', 'BT-45'),
(367, 'BT', 'Samtse', 'BT-14'),
(368, 'BT', 'Thimphu', 'BT-15'),
(369, 'BT', 'Trashigang', 'BT-41'),
(370, 'BT', 'Trongsa', 'BT-32'),
(371, 'BT', 'Tsirang', 'BT-21'),
(372, 'BT', 'Wangdue Phodrang', 'BT-24'),
(373, 'BV', 'Bouvet Island', '-'),
(374, 'BW', 'Central', 'BW-CE'),
(375, 'BW', 'Chobe', 'BW-CH'),
(376, 'BW', 'Kgalagadi', 'BW-KG'),
(377, 'BW', 'Kgatleng', 'BW-KL'),
(378, 'BW', 'Kweneng', 'BW-KW'),
(379, 'BW', 'North East', 'BW-NE'),
(380, 'BW', 'North West', 'BW-NW'),
(381, 'BW', 'South East', 'BW-SE'),
(382, 'BW', 'Southern', 'BW-SO'),
(383, 'BY', 'Brestskaya voblasts', 'BY-BR'),
(384, 'BY', 'Homyelskaya voblasts', 'BY-HO'),
(385, 'BY', 'Horad Minsk', 'BY-HM'),
(386, 'BY', 'Hrodzyenskaya voblasts', 'BY-HR'),
(387, 'BY', 'Mahilyowskaya voblasts', 'BY-MA'),
(388, 'BY', 'Minskaya voblasts', 'BY-MI'),
(389, 'BY', 'Vitsyebskaya voblasts', 'BY-VI'),
(390, 'BZ', 'Belize', 'BZ-BZ'),
(391, 'BZ', 'Cayo', 'BZ-CY'),
(392, 'BZ', 'Corozal', 'BZ-CZL'),
(393, 'BZ', 'Orange Walk', 'BZ-OW'),
(394, 'BZ', 'Stann Creek', 'BZ-SC'),
(395, 'BZ', 'Toledo', 'BZ-TOL'),
(396, 'CA', 'Alberta', 'CA-AB'),
(397, 'CA', 'British Columbia', 'CA-BC'),
(398, 'CA', 'Manitoba', 'CA-MB'),
(399, 'CA', 'New Brunswick', 'CA-NB'),
(400, 'CA', 'Newfoundland and Labrador', 'CA-NL'),
(401, 'CA', 'Northwest Territories', 'CA-NT'),
(402, 'CA', 'Nova Scotia', 'CA-NS'),
(403, 'CA', 'Nunavut', 'CA-NU'),
(404, 'CA', 'Ontario', 'CA-ON'),
(405, 'CA', 'Prince Edward Island', 'CA-PE'),
(406, 'CA', 'Quebec', 'CA-QC'),
(407, 'CA', 'Saskatchewan', 'CA-SK'),
(408, 'CA', 'Yukon', 'CA-YT'),
(409, 'CC', 'Cocos (Keeling) Islands', '-'),
(410, 'CD', 'Equateur', 'CD-EQ'),
(411, 'CD', 'Haut-Katanga', 'CD-HK'),
(412, 'CD', 'Ituri', 'CD-IT'),
(413, 'CD', 'Kasai Central', 'CD-KC'),
(414, 'CD', 'Kasai Oriental', 'CD-KE'),
(415, 'CD', 'Kinshasa', 'CD-KN'),
(416, 'CD', 'Kwilu', 'CD-KL'),
(417, 'CD', 'Lualaba', 'CD-LU'),
(418, 'CD', 'Mai-Ndombe', 'CD-MN'),
(419, 'CD', 'Nord-Kivu', 'CD-NK'),
(420, 'CD', 'Sankuru', 'CD-SA'),
(421, 'CD', 'Sud-Kivu', 'CD-SK'),
(422, 'CD', 'Tanganyika', 'CD-TA'),
(423, 'CD', 'Tshopo', 'CD-TO'),
(424, 'CF', 'Bangui', 'CF-BGF'),
(425, 'CF', 'Nana-Mambere', 'CF-NM'),
(426, 'CF', 'Ouham', 'CF-AC'),
(427, 'CF', 'Ouham-Pende', 'CF-OP'),
(428, 'CG', 'Brazzaville', 'CG-BZV'),
(429, 'CG', 'Cuvette', 'CG-8'),
(430, 'CG', 'Pointe-Noire', 'CG-16'),
(431, 'CG', 'Sangha', 'CG-13'),
(432, 'CH', 'Aargau', 'CH-AG'),
(433, 'CH', 'Appenzell Ausserrhoden', 'CH-AR'),
(434, 'CH', 'Appenzell Innerrhoden', 'CH-AI'),
(435, 'CH', 'Basel-Landschaft', 'CH-BL'),
(436, 'CH', 'Basel-Stadt', 'CH-BS'),
(437, 'CH', 'Bern', 'CH-BE'),
(438, 'CH', 'Fribourg', 'CH-FR'),
(439, 'CH', 'Geneve', 'CH-GE'),
(440, 'CH', 'Glarus', 'CH-GL'),
(441, 'CH', 'Graubunden', 'CH-GR'),
(442, 'CH', 'Jura', 'CH-JU'),
(443, 'CH', 'Luzern', 'CH-LU'),
(444, 'CH', 'Neuchatel', 'CH-NE'),
(445, 'CH', 'Nidwalden', 'CH-NW'),
(446, 'CH', 'Obwalden', 'CH-OW'),
(447, 'CH', 'Sankt Gallen', 'CH-SG'),
(448, 'CH', 'Schaffhausen', 'CH-SH'),
(449, 'CH', 'Schwyz', 'CH-SZ'),
(450, 'CH', 'Solothurn', 'CH-SO'),
(451, 'CH', 'Thurgau', 'CH-TG'),
(452, 'CH', 'Ticino', 'CH-TI'),
(453, 'CH', 'Uri', 'CH-UR'),
(454, 'CH', 'Valais', 'CH-VS'),
(455, 'CH', 'Vaud', 'CH-VD'),
(456, 'CH', 'Zug', 'CH-ZG'),
(457, 'CH', 'Zurich', 'CH-ZH'),
(458, 'CI', 'Abidjan', 'CI-AB'),
(459, 'CI', 'Bas-Sassandra', 'CI-BS'),
(460, 'CI', 'Comoe', 'CI-CM'),
(461, 'CI', 'Denguele', 'CI-DN'),
(462, 'CI', 'Goh-Djiboua', 'CI-GD'),
(463, 'CI', 'Lacs', 'CI-LC'),
(464, 'CI', 'Lagunes', 'CI-LG'),
(465, 'CI', 'Montagnes', 'CI-MG'),
(466, 'CI', 'Sassandra-Marahoue', 'CI-SM'),
(467, 'CI', 'Savanes', 'CI-SV'),
(468, 'CI', 'Vallee du Bandama', 'CI-VB'),
(469, 'CI', 'Woroba', 'CI-WR'),
(470, 'CI', 'Yamoussoukro', 'CI-YM'),
(471, 'CI', 'Zanzan', 'CI-ZZ'),
(472, 'CK', 'Cook Islands', '-'),
(473, 'CL', 'Aisen del General Carlos Ibanez del Campo', 'CL-AI'),
(474, 'CL', 'Antofagasta', 'CL-AN'),
(475, 'CL', 'Arica y Parinacota', 'CL-AP'),
(476, 'CL', 'Atacama', 'CL-AT'),
(477, 'CL', 'Biobio', 'CL-BI'),
(478, 'CL', 'Coquimbo', 'CL-CO'),
(479, 'CL', 'La Araucania', 'CL-AR'),
(480, 'CL', 'Libertador General Bernardo OHiggins', 'CL-LI'),
(481, 'CL', 'Los Lagos', 'CL-LL'),
(482, 'CL', 'Los Rios', 'CL-LR'),
(483, 'CL', 'Magallanes', 'CL-MA'),
(484, 'CL', 'Maule', 'CL-ML'),
(485, 'CL', 'Nuble', 'CL-NB'),
(486, 'CL', 'Region Metropolitana de Santiago', 'CL-RM'),
(487, 'CL', 'Tarapaca', 'CL-TA'),
(488, 'CL', 'Valparaiso', 'CL-VS'),
(489, 'CM', 'Adamaoua', 'CM-AD'),
(490, 'CM', 'Centre', 'CM-CE'),
(491, 'CM', 'Est', 'CM-ES'),
(492, 'CM', 'Extreme-Nord', 'CM-EN'),
(493, 'CM', 'Littoral', 'CM-LT'),
(494, 'CM', 'Nord', 'CM-NO'),
(495, 'CM', 'Nord-Ouest', 'CM-NW'),
(496, 'CM', 'Ouest', 'CM-OU'),
(497, 'CM', 'Sud', 'CM-SU'),
(498, 'CM', 'Sud-Ouest', 'CM-SW'),
(499, 'CN', 'Anhui', 'CN-AH'),
(500, 'CN', 'Beijing', 'CN-BJ'),
(501, 'CN', 'Chongqing', 'CN-CQ'),
(502, 'CN', 'Fujian', 'CN-FJ'),
(503, 'CN', 'Gansu', 'CN-GS'),
(504, 'CN', 'Guangdong', 'CN-GD'),
(505, 'CN', 'Guangxi', 'CN-GX'),
(506, 'CN', 'Guizhou', 'CN-GZ'),
(507, 'CN', 'Hainan', 'CN-HI'),
(508, 'CN', 'Hebei', 'CN-HE'),
(509, 'CN', 'Heilongjiang', 'CN-HL'),
(510, 'CN', 'Henan', 'CN-HA'),
(511, 'CN', 'Hubei', 'CN-HB'),
(512, 'CN', 'Hunan', 'CN-HN'),
(513, 'CN', 'Jiangsu', 'CN-JS'),
(514, 'CN', 'Jiangxi', 'CN-JX'),
(515, 'CN', 'Jilin', 'CN-JL'),
(516, 'CN', 'Liaoning', 'CN-LN'),
(517, 'CN', 'Nei Mongol', 'CN-NM'),
(518, 'CN', 'Ningxia', 'CN-NX'),
(519, 'CN', 'Qinghai', 'CN-QH'),
(520, 'CN', 'Shaanxi', 'CN-SN'),
(521, 'CN', 'Shandong', 'CN-SD'),
(522, 'CN', 'Shanghai', 'CN-SH'),
(523, 'CN', 'Shanxi', 'CN-SX'),
(524, 'CN', 'Sichuan', 'CN-SC'),
(525, 'CN', 'Tianjin', 'CN-TJ'),
(526, 'CN', 'Xinjiang', 'CN-XJ'),
(527, 'CN', 'Xizang', 'CN-XZ'),
(528, 'CN', 'Yunnan', 'CN-YN'),
(529, 'CN', 'Zhejiang', 'CN-ZJ'),
(530, 'CO', 'Amazonas', 'CO-AMA'),
(531, 'CO', 'Antioquia', 'CO-ANT'),
(532, 'CO', 'Arauca', 'CO-ARA'),
(533, 'CO', 'Atlantico', 'CO-ATL'),
(534, 'CO', 'Bolivar', 'CO-BOL'),
(535, 'CO', 'Boyaca', 'CO-BOY'),
(536, 'CO', 'Caldas', 'CO-CAL'),
(537, 'CO', 'Caqueta', 'CO-CAQ'),
(538, 'CO', 'Casanare', 'CO-CAS'),
(539, 'CO', 'Cauca', 'CO-CAU'),
(540, 'CO', 'Cesar', 'CO-CES'),
(541, 'CO', 'Choco', 'CO-CHO'),
(542, 'CO', 'Cordoba', 'CO-COR'),
(543, 'CO', 'Cundinamarca', 'CO-CUN'),
(544, 'CO', 'Distrito Capital de Bogota', 'CO-DC'),
(545, 'CO', 'Guainia', 'CO-GUA'),
(546, 'CO', 'Guaviare', 'CO-GUV'),
(547, 'CO', 'Huila', 'CO-HUI'),
(548, 'CO', 'La Guajira', 'CO-LAG'),
(549, 'CO', 'Magdalena', 'CO-MAG'),
(550, 'CO', 'Meta', 'CO-MET'),
(551, 'CO', 'Narino', 'CO-NAR'),
(552, 'CO', 'Norte de Santander', 'CO-NSA'),
(553, 'CO', 'Putumayo', 'CO-PUT'),
(554, 'CO', 'Quindio', 'CO-QUI'),
(555, 'CO', 'Risaralda', 'CO-RIS'),
(556, 'CO', 'San Andres, Providencia y Santa Catalina', 'CO-SAP'),
(557, 'CO', 'Santander', 'CO-SAN'),
(558, 'CO', 'Sucre', 'CO-SUC'),
(559, 'CO', 'Tolima', 'CO-TOL'),
(560, 'CO', 'Valle del Cauca', 'CO-VAC'),
(561, 'CO', 'Vichada', 'CO-VID'),
(562, 'CR', 'Alajuela', 'CR-A'),
(563, 'CR', 'Cartago', 'CR-C'),
(564, 'CR', 'Guanacaste', 'CR-G'),
(565, 'CR', 'Heredia', 'CR-H'),
(566, 'CR', 'Limon', 'CR-L'),
(567, 'CR', 'Puntarenas', 'CR-P'),
(568, 'CR', 'San Jose', 'CR-SJ'),
(569, 'CU', 'Artemisa', 'CU-15'),
(570, 'CU', 'Camaguey', 'CU-09'),
(571, 'CU', 'Ciego de Avila', 'CU-08'),
(572, 'CU', 'Cienfuegos', 'CU-06'),
(573, 'CU', 'Granma', 'CU-12'),
(574, 'CU', 'Guantanamo', 'CU-14'),
(575, 'CU', 'Holguin', 'CU-11'),
(576, 'CU', 'La Habana', 'CU-03'),
(577, 'CU', 'Las Tunas', 'CU-10'),
(578, 'CU', 'Matanzas', 'CU-04'),
(579, 'CU', 'Mayabeque', 'CU-16'),
(580, 'CU', 'Pinar del Rio', 'CU-01'),
(581, 'CU', 'Sancti Spiritus', 'CU-07'),
(582, 'CU', 'Santiago de Cuba', 'CU-13'),
(583, 'CU', 'Villa Clara', 'CU-05'),
(584, 'CV', 'Boa Vista', 'CV-BV'),
(585, 'CV', 'Brava', 'CV-BR'),
(586, 'CV', 'Maio', 'CV-MA'),
(587, 'CV', 'Porto Novo', 'CV-PN'),
(588, 'CV', 'Praia', 'CV-PR'),
(589, 'CV', 'Ribeira Grande', 'CV-RG'),
(590, 'CV', 'Ribeira Grande de Santiago', 'CV-RS'),
(591, 'CV', 'Sal', 'CV-SL'),
(592, 'CV', 'Santa Cruz', 'CV-CR'),
(593, 'CV', 'Sao Vicente', 'CV-SV'),
(594, 'CV', 'Tarrafal', 'CV-TA'),
(595, 'CW', 'Curacao', '-'),
(596, 'CX', 'Christmas Island', '-'),
(597, 'CY', 'Ammochostos', 'CY-04'),
(598, 'CY', 'Keryneia', 'CY-06'),
(599, 'CY', 'Larnaka', 'CY-03'),
(600, 'CY', 'Lefkosia', 'CY-01'),
(601, 'CY', 'Lemesos', 'CY-02'),
(602, 'CY', 'Pafos', 'CY-05'),
(603, 'CZ', 'Jihocesky kraj', 'CZ-31'),
(604, 'CZ', 'Jihomoravsky kraj', 'CZ-64'),
(605, 'CZ', 'Karlovarsky kraj', 'CZ-41'),
(606, 'CZ', 'Kraj Vysocina', 'CZ-63'),
(607, 'CZ', 'Kralovehradecky kraj', 'CZ-52'),
(608, 'CZ', 'Liberecky kraj', 'CZ-51'),
(609, 'CZ', 'Moravskoslezsky kraj', 'CZ-80'),
(610, 'CZ', 'Olomoucky kraj', 'CZ-71'),
(611, 'CZ', 'Pardubicky kraj', 'CZ-53'),
(612, 'CZ', 'Plzensky kraj', 'CZ-32'),
(613, 'CZ', 'Praha, Hlavni mesto', 'CZ-10'),
(614, 'CZ', 'Stredocesky kraj', 'CZ-20'),
(615, 'CZ', 'Ustecky kraj', 'CZ-42'),
(616, 'CZ', 'Zlinsky kraj', 'CZ-72'),
(617, 'DE', 'Baden-Wurttemberg', 'DE-BW'),
(618, 'DE', 'Bayern', 'DE-BY'),
(619, 'DE', 'Berlin', 'DE-BE'),
(620, 'DE', 'Brandenburg', 'DE-BB'),
(621, 'DE', 'Bremen', 'DE-HB'),
(622, 'DE', 'Hamburg', 'DE-HH'),
(623, 'DE', 'Hessen', 'DE-HE'),
(624, 'DE', 'Mecklenburg-Vorpommern', 'DE-MV'),
(625, 'DE', 'Niedersachsen', 'DE-NI'),
(626, 'DE', 'Nordrhein-Westfalen', 'DE-NW'),
(627, 'DE', 'Rheinland-Pfalz', 'DE-RP'),
(628, 'DE', 'Saarland', 'DE-SL'),
(629, 'DE', 'Sachsen', 'DE-SN'),
(630, 'DE', 'Sachsen-Anhalt', 'DE-ST'),
(631, 'DE', 'Schleswig-Holstein', 'DE-SH'),
(632, 'DE', 'Thuringen', 'DE-TH'),
(633, 'DJ', 'Djibouti', 'DJ-DJ'),
(634, 'DK', 'Hovedstaden', 'DK-84'),
(635, 'DK', 'Midtjylland', 'DK-82'),
(636, 'DK', 'Nordjylland', 'DK-81'),
(637, 'DK', 'Sjaelland', 'DK-85'),
(638, 'DK', 'Syddanmark', 'DK-83'),
(639, 'DM', 'Saint Andrew', 'DM-02'),
(640, 'DM', 'Saint George', 'DM-04'),
(641, 'DM', 'Saint John', 'DM-05'),
(642, 'DM', 'Saint Patrick', 'DM-09'),
(643, 'DM', 'Saint Paul', 'DM-10'),
(644, 'DO', 'Azua', 'DO-02'),
(645, 'DO', 'Baoruco', 'DO-03'),
(646, 'DO', 'Barahona', 'DO-04'),
(647, 'DO', 'Dajabon', 'DO-05'),
(648, 'DO', 'Distrito Nacional (Santo Domingo)', 'DO-01'),
(649, 'DO', 'Duarte', 'DO-06'),
(650, 'DO', 'El Seibo', 'DO-08'),
(651, 'DO', 'Elias Pina', 'DO-07'),
(652, 'DO', 'Espaillat', 'DO-09'),
(653, 'DO', 'Hato Mayor', 'DO-30'),
(654, 'DO', 'Hermanas Mirabal', 'DO-19'),
(655, 'DO', 'Independencia', 'DO-10'),
(656, 'DO', 'La Altagracia', 'DO-11'),
(657, 'DO', 'La Romana', 'DO-12'),
(658, 'DO', 'La Vega', 'DO-13'),
(659, 'DO', 'Maria Trinidad Sanchez', 'DO-14'),
(660, 'DO', 'Monsenor Nouel', 'DO-28'),
(661, 'DO', 'Monte Cristi', 'DO-15'),
(662, 'DO', 'Monte Plata', 'DO-29'),
(663, 'DO', 'Peravia', 'DO-17'),
(664, 'DO', 'Puerto Plata', 'DO-18'),
(665, 'DO', 'Samana', 'DO-20'),
(666, 'DO', 'San Cristobal', 'DO-21'),
(667, 'DO', 'San Jose de Ocoa', 'DO-31'),
(668, 'DO', 'San Juan', 'DO-22'),
(669, 'DO', 'San Pedro de Macoris', 'DO-23'),
(670, 'DO', 'Sanchez Ramirez', 'DO-24'),
(671, 'DO', 'Santiago', 'DO-25'),
(672, 'DO', 'Santiago Rodriguez', 'DO-26'),
(673, 'DO', 'Valverde', 'DO-27'),
(674, 'DZ', 'Adrar', 'DZ-01'),
(675, 'DZ', 'Ain Defla', 'DZ-44'),
(676, 'DZ', 'Ain Temouchent', 'DZ-46'),
(677, 'DZ', 'Alger', 'DZ-16'),
(678, 'DZ', 'Annaba', 'DZ-23'),
(679, 'DZ', 'Batna', 'DZ-05'),
(680, 'DZ', 'Bechar', 'DZ-08'),
(681, 'DZ', 'Bejaia', 'DZ-06'),
(682, 'DZ', 'Biskra', 'DZ-07'),
(683, 'DZ', 'Blida', 'DZ-09'),
(684, 'DZ', 'Bordj Bou Arreridj', 'DZ-34'),
(685, 'DZ', 'Bouira', 'DZ-10'),
(686, 'DZ', 'Boumerdes', 'DZ-35'),
(687, 'DZ', 'Chlef', 'DZ-02'),
(688, 'DZ', 'Constantine', 'DZ-25'),
(689, 'DZ', 'Djelfa', 'DZ-17'),
(690, 'DZ', 'El Bayadh', 'DZ-32'),
(691, 'DZ', 'El Oued', 'DZ-39'),
(692, 'DZ', 'El Tarf', 'DZ-36'),
(693, 'DZ', 'Ghardaia', 'DZ-47'),
(694, 'DZ', 'Guelma', 'DZ-24'),
(695, 'DZ', 'Illizi', 'DZ-33'),
(696, 'DZ', 'Jijel', 'DZ-18'),
(697, 'DZ', 'Khenchela', 'DZ-40'),
(698, 'DZ', 'Laghouat', 'DZ-03'),
(699, 'DZ', 'Msila', 'DZ-28'),
(700, 'DZ', 'Mascara', 'DZ-29'),
(701, 'DZ', 'Medea', 'DZ-26'),
(702, 'DZ', 'Mila', 'DZ-43'),
(703, 'DZ', 'Mostaganem', 'DZ-27'),
(704, 'DZ', 'Naama', 'DZ-45'),
(705, 'DZ', 'Oran', 'DZ-31'),
(706, 'DZ', 'Ouargla', 'DZ-30'),
(707, 'DZ', 'Oum el Bouaghi', 'DZ-04'),
(708, 'DZ', 'Relizane', 'DZ-48'),
(709, 'DZ', 'Saida', 'DZ-20'),
(710, 'DZ', 'Setif', 'DZ-19'),
(711, 'DZ', 'Sidi Bel Abbes', 'DZ-22'),
(712, 'DZ', 'Skikda', 'DZ-21'),
(713, 'DZ', 'Souk Ahras', 'DZ-41'),
(714, 'DZ', 'Tamanrasset', 'DZ-11'),
(715, 'DZ', 'Tebessa', 'DZ-12'),
(716, 'DZ', 'Tiaret', 'DZ-14'),
(717, 'DZ', 'Tindouf', 'DZ-37'),
(718, 'DZ', 'Tipaza', 'DZ-42'),
(719, 'DZ', 'Tissemsilt', 'DZ-38'),
(720, 'DZ', 'Tizi Ouzou', 'DZ-15'),
(721, 'DZ', 'Tlemcen', 'DZ-13'),
(722, 'EC', 'Azuay', 'EC-A'),
(723, 'EC', 'Bolivar', 'EC-B'),
(724, 'EC', 'Canar', 'EC-F'),
(725, 'EC', 'Carchi', 'EC-C'),
(726, 'EC', 'Chimborazo', 'EC-H'),
(727, 'EC', 'Cotopaxi', 'EC-X'),
(728, 'EC', 'El Oro', 'EC-O'),
(729, 'EC', 'Esmeraldas', 'EC-E'),
(730, 'EC', 'Galapagos', 'EC-W'),
(731, 'EC', 'Guayas', 'EC-G'),
(732, 'EC', 'Imbabura', 'EC-I'),
(733, 'EC', 'Loja', 'EC-L'),
(734, 'EC', 'Los Rios', 'EC-R'),
(735, 'EC', 'Manabi', 'EC-M'),
(736, 'EC', 'Morona Santiago', 'EC-S'),
(737, 'EC', 'Napo', 'EC-N'),
(738, 'EC', 'Orellana', 'EC-D'),
(739, 'EC', 'Pastaza', 'EC-Y'),
(740, 'EC', 'Pichincha', 'EC-P'),
(741, 'EC', 'Santa Elena', 'EC-SE'),
(742, 'EC', 'Santo Domingo de los Tsachilas', 'EC-SD'),
(743, 'EC', 'Sucumbios', 'EC-U'),
(744, 'EC', 'Tungurahua', 'EC-T'),
(745, 'EC', 'Zamora Chinchipe', 'EC-Z'),
(746, 'EE', 'Harjumaa', 'EE-37'),
(747, 'EE', 'Hiiumaa', 'EE-39'),
(748, 'EE', 'Ida-Virumaa', 'EE-45'),
(749, 'EE', 'Jarvamaa', 'EE-52'),
(750, 'EE', 'Jogevamaa', 'EE-50'),
(751, 'EE', 'Laane-Virumaa', 'EE-60'),
(752, 'EE', 'Laanemaa', 'EE-56'),
(753, 'EE', 'Parnumaa', 'EE-68'),
(754, 'EE', 'Polvamaa', 'EE-64'),
(755, 'EE', 'Raplamaa', 'EE-71'),
(756, 'EE', 'Saaremaa', 'EE-74'),
(757, 'EE', 'Tartumaa', 'EE-79'),
(758, 'EE', 'Valgamaa', 'EE-81'),
(759, 'EE', 'Viljandimaa', 'EE-84'),
(760, 'EE', 'Vorumaa', 'EE-87'),
(761, 'EG', 'Ad Daqahliyah', 'EG-DK'),
(762, 'EG', 'Al Bahr al Ahmar', 'EG-BA'),
(763, 'EG', 'Al Buhayrah', 'EG-BH'),
(764, 'EG', 'Al Fayyum', 'EG-FYM'),
(765, 'EG', 'Al Gharbiyah', 'EG-GH'),
(766, 'EG', 'Al Iskandariyah', 'EG-ALX'),
(767, 'EG', 'Al Ismailiyah', 'EG-IS'),
(768, 'EG', 'Al Jizah', 'EG-GZ'),
(769, 'EG', 'Al Minufiyah', 'EG-MNF'),
(770, 'EG', 'Al Minya', 'EG-MN'),
(771, 'EG', 'Al Qahirah', 'EG-C'),
(772, 'EG', 'Al Qalyubiyah', 'EG-KB'),
(773, 'EG', 'Al Uqsur', 'EG-LX'),
(774, 'EG', 'Al Wadi al Jadid', 'EG-WAD'),
(775, 'EG', 'As Suways', 'EG-SUZ'),
(776, 'EG', 'Ash Sharqiyah', 'EG-SHR'),
(777, 'EG', 'Aswan', 'EG-ASN'),
(778, 'EG', 'Asyut', 'EG-AST'),
(779, 'EG', 'Bani Suwayf', 'EG-BNS'),
(780, 'EG', 'Bur Said', 'EG-PTS'),
(781, 'EG', 'Dumyat', 'EG-DT'),
(782, 'EG', 'Janub Sina', 'EG-JS'),
(783, 'EG', 'Kafr ash Shaykh', 'EG-KFS'),
(784, 'EG', 'Matruh', 'EG-MT'),
(785, 'EG', 'Qina', 'EG-KN'),
(786, 'EG', 'Shamal Sina', 'EG-SIN'),
(787, 'EG', 'Suhaj', 'EG-SHG'),
(788, 'ER', 'Al Awsat', 'ER-MA'),
(789, 'ES', 'Andalucia', 'ES-AN'),
(790, 'ES', 'Aragon', 'ES-AR'),
(791, 'ES', 'Asturias, Principado de', 'ES-AS'),
(792, 'ES', 'Canarias', 'ES-CN'),
(793, 'ES', 'Cantabria', 'ES-CB'),
(794, 'ES', 'Castilla y Leon', 'ES-CL'),
(795, 'ES', 'Castilla-La Mancha', 'ES-CM'),
(796, 'ES', 'Catalunya', 'ES-CT'),
(797, 'ES', 'Ceuta', 'ES-CE'),
(798, 'ES', 'Extremadura', 'ES-EX'),
(799, 'ES', 'Galicia', 'ES-GA'),
(800, 'ES', 'Illes Balears', 'ES-IB'),
(801, 'ES', 'La Rioja', 'ES-RI'),
(802, 'ES', 'Madrid, Comunidad de', 'ES-MD'),
(803, 'ES', 'Melilla', 'ES-ML'),
(804, 'ES', 'Murcia, Region de', 'ES-MC'),
(805, 'ES', 'Navarra, Comunidad Foral de', 'ES-NC'),
(806, 'ES', 'Pais Vasco', 'ES-PV'),
(807, 'ES', 'Valenciana, Comunidad', 'ES-VC'),
(808, 'ET', 'Adis Abeba', 'ET-AA'),
(809, 'ET', 'Afar', 'ET-AF'),
(810, 'ET', 'Amara', 'ET-AM'),
(811, 'ET', 'Binshangul Gumuz', 'ET-BE'),
(812, 'ET', 'Dire Dawa', 'ET-DD'),
(813, 'ET', 'Hareri Hizb', 'ET-HA'),
(814, 'ET', 'Oromiya', 'ET-OR'),
(815, 'ET', 'Sumale', 'ET-SO'),
(816, 'ET', 'Tigray', 'ET-TI'),
(817, 'ET', 'YeDebub Biheroch Bihereseboch na Hizboch', 'ET-SN'),
(818, 'FI', 'Etela-Karjala', 'FI-02'),
(819, 'FI', 'Etela-Pohjanmaa', 'FI-03'),
(820, 'FI', 'Etela-Savo', 'FI-04'),
(821, 'FI', 'Kainuu', 'FI-05'),
(822, 'FI', 'Kanta-Hame', 'FI-06'),
(823, 'FI', 'Keski-Pohjanmaa', 'FI-07'),
(824, 'FI', 'Keski-Suomi', 'FI-08'),
(825, 'FI', 'Kymenlaakso', 'FI-09'),
(826, 'FI', 'Lappi', 'FI-10'),
(827, 'FI', 'Paijat-Hame', 'FI-16'),
(828, 'FI', 'Pirkanmaa', 'FI-11'),
(829, 'FI', 'Pohjanmaa', 'FI-12'),
(830, 'FI', 'Pohjois-Karjala', 'FI-13'),
(831, 'FI', 'Pohjois-Pohjanmaa', 'FI-14'),
(832, 'FI', 'Pohjois-Savo', 'FI-15'),
(833, 'FI', 'Satakunta', 'FI-17'),
(834, 'FI', 'Uusimaa', 'FI-18'),
(835, 'FI', 'Varsinais-Suomi', 'FI-19'),
(836, 'FJ', 'Central', 'FJ-C'),
(837, 'FJ', 'Eastern', 'FJ-E'),
(838, 'FJ', 'Northern', 'FJ-N'),
(839, 'FJ', 'Rotuma', 'FJ-R'),
(840, 'FJ', 'Western', 'FJ-W'),
(841, 'FK', 'Falkland Islands (Malvinas)', '-'),
(842, 'FM', 'Chuuk', 'FM-TRK'),
(843, 'FM', 'Kosrae', 'FM-KSA'),
(844, 'FM', 'Pohnpei', 'FM-PNI'),
(845, 'FM', 'Yap', 'FM-YAP'),
(846, 'FO', 'Eysturoy', '-'),
(847, 'FO', 'Nordoyar', '-'),
(848, 'FO', 'Streymoy', '-'),
(849, 'FO', 'Suduroy', '-'),
(850, 'FO', 'Vagar', '-'),
(851, 'FR', 'Auvergne-Rhone-Alpes', 'FR-ARA'),
(852, 'FR', 'Bourgogne-Franche-Comte', 'FR-BFC'),
(853, 'FR', 'Bretagne', 'FR-BRE'),
(854, 'FR', 'Centre-Val de Loire', 'FR-CVL'),
(855, 'FR', 'Corse', 'FR-20R'),
(856, 'FR', 'Grand-Est', 'FR-GES'),
(857, 'FR', 'Hauts-de-France', 'FR-HDF'),
(858, 'FR', 'Ile-de-France', 'FR-IDF'),
(859, 'FR', 'Normandie', 'FR-NOR'),
(860, 'FR', 'Nouvelle-Aquitaine', 'FR-NAQ'),
(861, 'FR', 'Occitanie', 'FR-OCC'),
(862, 'FR', 'Pays-de-la-Loire', 'FR-PDL'),
(863, 'FR', 'Provence-Alpes-Cote-dAzur', 'FR-PAC'),
(864, 'GA', 'Estuaire', 'GA-1'),
(865, 'GA', 'Haut-Ogooue', 'GA-2'),
(866, 'GA', 'Ngounie', 'GA-4'),
(867, 'GA', 'Ogooue-Maritime', 'GA-8'),
(868, 'GA', 'Woleu-Ntem', 'GA-9'),
(869, 'GB', 'England', 'GB-ENG'),
(870, 'GB', 'Northern Ireland', 'GB-NIR'),
(871, 'GB', 'Scotland', 'GB-SCT'),
(872, 'GB', 'Wales', 'GB-WLS'),
(873, 'GD', 'Saint Andrew', 'GD-01'),
(874, 'GD', 'Saint David', 'GD-02'),
(875, 'GD', 'Saint George', 'GD-03'),
(876, 'GD', 'Saint John', 'GD-04'),
(877, 'GD', 'Saint Mark', 'GD-05'),
(878, 'GD', 'Southern Grenadine Islands', 'GD-10'),
(879, 'GE', 'Abkhazia', 'GE-AB'),
(880, 'GE', 'Ajaria', 'GE-AJ'),
(881, 'GE', 'Guria', 'GE-GU'),
(882, 'GE', 'Imereti', 'GE-IM'),
(883, 'GE', 'Kakheti', 'GE-KA'),
(884, 'GE', 'Kvemo Kartli', 'GE-KK'),
(885, 'GE', 'Mtskheta-Mtianeti', 'GE-MM'),
(886, 'GE', 'Racha-Lechkhumi-Kvemo Svaneti', 'GE-RL'),
(887, 'GE', 'Samegrelo-Zemo Svaneti', 'GE-SZ'),
(888, 'GE', 'Samtskhe-Javakheti', 'GE-SJ'),
(889, 'GE', 'Shida Kartli', 'GE-SK'),
(890, 'GE', 'Tbilisi', 'GE-TB'),
(891, 'GF', 'Guyane', '-'),
(892, 'GG', 'Guernsey', '-'),
(893, 'GH', 'Ashanti', 'GH-AH'),
(894, 'GH', 'Bono', 'GH-BO'),
(895, 'GH', 'Bono East', 'GH-BE'),
(896, 'GH', 'Central', 'GH-CP'),
(897, 'GH', 'Eastern', 'GH-EP'),
(898, 'GH', 'Greater Accra', 'GH-AA'),
(899, 'GH', 'Northern', 'GH-NP'),
(900, 'GH', 'Upper East', 'GH-UE'),
(901, 'GH', 'Volta', 'GH-TV'),
(902, 'GH', 'Western', 'GH-WP'),
(903, 'GI', 'Gibraltar', '-'),
(904, 'GL', 'Avannaata Kommunia', 'GL-AV'),
(905, 'GL', 'Kommune Kujalleq', 'GL-KU'),
(906, 'GL', 'Kommune Qeqertalik', 'GL-QT'),
(907, 'GL', 'Kommuneqarfik Sermersooq', 'GL-SM'),
(908, 'GL', 'Qeqqata Kommunia', 'GL-QE'),
(909, 'GM', 'Banjul', 'GM-B'),
(910, 'GM', 'Central River', 'GM-M'),
(911, 'GM', 'Lower River', 'GM-L'),
(912, 'GM', 'North Bank', 'GM-N'),
(913, 'GM', 'Upper River', 'GM-U'),
(914, 'GM', 'Western', 'GM-W'),
(915, 'GN', 'Boffa', 'GN-BF'),
(916, 'GN', 'Boke', 'GN-B'),
(917, 'GN', 'Conakry', 'GN-C'),
(918, 'GN', 'Coyah', 'GN-CO'),
(919, 'GN', 'Dabola', 'GN-DB'),
(920, 'GN', 'Kankan', 'GN-K'),
(921, 'GN', 'Kindia', 'GN-D'),
(922, 'GN', 'Labe', 'GN-L'),
(923, 'GN', 'Labe', 'GN-LA'),
(924, 'GN', 'Nzerekore', 'GN-N'),
(925, 'GN', 'Siguiri', 'GN-SI'),
(926, 'GP', 'Guadeloupe', '-'),
(927, 'GQ', 'Bioko Norte', 'GQ-BN'),
(928, 'GQ', 'Litoral', 'GQ-LI'),
(929, 'GQ', 'Wele-Nzas', 'GQ-WN'),
(930, 'GR', 'Agion Oros', 'GR-69'),
(931, 'GR', 'Anatoliki Makedonia kai Thraki', 'GR-A'),
(932, 'GR', 'Attiki', 'GR-I'),
(933, 'GR', 'Dytiki Ellada', 'GR-G'),
(934, 'GR', 'Dytiki Makedonia', 'GR-C'),
(935, 'GR', 'Ionia Nisia', 'GR-F'),
(936, 'GR', 'Ipeiros', 'GR-D'),
(937, 'GR', 'Kentriki Makedonia', 'GR-B'),
(938, 'GR', 'Kriti', 'GR-M'),
(939, 'GR', 'Notio Aigaio', 'GR-L'),
(940, 'GR', 'Peloponnisos', 'GR-J'),
(941, 'GR', 'Sterea Ellada', 'GR-H'),
(942, 'GR', 'Thessalia', 'GR-E'),
(943, 'GR', 'Voreio Aigaio', 'GR-K'),
(944, 'GS', 'South Georgia and the South Sandwich Islands', '-'),
(945, 'GT', 'Alta Verapaz', 'GT-AV'),
(946, 'GT', 'Baja Verapaz', 'GT-BV'),
(947, 'GT', 'Chimaltenango', 'GT-CM'),
(948, 'GT', 'Chiquimula', 'GT-CQ'),
(949, 'GT', 'El Progreso', 'GT-PR'),
(950, 'GT', 'Escuintla', 'GT-ES'),
(951, 'GT', 'Guatemala', 'GT-GU'),
(952, 'GT', 'Huehuetenango', 'GT-HU'),
(953, 'GT', 'Izabal', 'GT-IZ'),
(954, 'GT', 'Jalapa', 'GT-JA'),
(955, 'GT', 'Jutiapa', 'GT-JU'),
(956, 'GT', 'Peten', 'GT-PE'),
(957, 'GT', 'Quetzaltenango', 'GT-QZ'),
(958, 'GT', 'Quiche', 'GT-QC'),
(959, 'GT', 'Retalhuleu', 'GT-RE'),
(960, 'GT', 'Sacatepequez', 'GT-SA'),
(961, 'GT', 'San Marcos', 'GT-SM'),
(962, 'GT', 'Santa Rosa', 'GT-SR'),
(963, 'GT', 'Solola', 'GT-SO'),
(964, 'GT', 'Suchitepequez', 'GT-SU'),
(965, 'GT', 'Totonicapan', 'GT-TO'),
(966, 'GT', 'Zacapa', 'GT-ZA'),
(967, 'GU', 'Agat', '-'),
(968, 'GU', 'Barrigada', '-'),
(969, 'GU', 'Chalan Pago-Ordot', '-'),
(970, 'GU', 'Dededo', '-'),
(971, 'GU', 'Hagatna', '-'),
(972, 'GU', 'Inarajan', '-'),
(973, 'GU', 'Mangilao', '-'),
(974, 'GU', 'Mongmong-Toto-Maite', '-'),
(975, 'GU', 'Piti', '-'),
(976, 'GU', 'Santa Rita', '-'),
(977, 'GU', 'Sinajana', '-'),
(978, 'GU', 'Talofofo', '-'),
(979, 'GU', 'Tamuning-Tumon-Harmon', '-'),
(980, 'GU', 'Yigo', '-'),
(981, 'GU', 'Yona', '-'),
(982, 'GW', 'Bissau', 'GW-BS'),
(983, 'GW', 'Gabu', 'GW-GA'),
(984, 'GY', 'Barima-Waini', 'GY-BA'),
(985, 'GY', 'Cuyuni-Mazaruni', 'GY-CU'),
(986, 'GY', 'Demerara-Mahaica', 'GY-DE'),
(987, 'GY', 'East Berbice-Corentyne', 'GY-EB'),
(988, 'GY', 'Essequibo Islands-West Demerara', 'GY-ES'),
(989, 'GY', 'Mahaica-Berbice', 'GY-MA'),
(990, 'GY', 'Potaro-Siparuni', 'GY-PT'),
(991, 'GY', 'Upper Demerara-Berbice', 'GY-UD'),
(992, 'HK', 'Hong Kong', '-'),
(993, 'HN', 'Atlantida', 'HN-AT'),
(994, 'HN', 'Choluteca', 'HN-CH'),
(995, 'HN', 'Colon', 'HN-CL'),
(996, 'HN', 'Comayagua', 'HN-CM'),
(997, 'HN', 'Copan', 'HN-CP'),
(998, 'HN', 'Cortes', 'HN-CR'),
(999, 'HN', 'El Paraiso', 'HN-EP'),
(1000, 'HN', 'Francisco Morazan', 'HN-FM'),
(1001, 'HN', 'Intibuca', 'HN-IN'),
(1002, 'HN', 'Islas de la Bahia', 'HN-IB'),
(1003, 'HN', 'La Paz', 'HN-LP'),
(1004, 'HN', 'Lempira', 'HN-LE'),
(1005, 'HN', 'Ocotepeque', 'HN-OC'),
(1006, 'HN', 'Olancho', 'HN-OL'),
(1007, 'HN', 'Santa Barbara', 'HN-SB'),
(1008, 'HN', 'Valle', 'HN-VA'),
(1009, 'HN', 'Yoro', 'HN-YO'),
(1010, 'HR', 'Bjelovarsko-bilogorska zupanija', 'HR-07'),
(1011, 'HR', 'Brodsko-posavska zupanija', 'HR-12'),
(1012, 'HR', 'Dubrovacko-neretvanska zupanija', 'HR-19'),
(1013, 'HR', 'Grad Zagreb', 'HR-21'),
(1014, 'HR', 'Istarska zupanija', 'HR-18'),
(1015, 'HR', 'Karlovacka zupanija', 'HR-04'),
(1016, 'HR', 'Koprivnicko-krizevacka zupanija', 'HR-06'),
(1017, 'HR', 'Krapinsko-zagorska zupanija', 'HR-02'),
(1018, 'HR', 'Licko-senjska zupanija', 'HR-09'),
(1019, 'HR', 'Medimurska zupanija', 'HR-20'),
(1020, 'HR', 'Osjecko-baranjska zupanija', 'HR-14'),
(1021, 'HR', 'Pozesko-slavonska zupanija', 'HR-11'),
(1022, 'HR', 'Primorsko-goranska zupanija', 'HR-08'),
(1023, 'HR', 'Sibensko-kninska zupanija', 'HR-15'),
(1024, 'HR', 'Sisacko-moslavacka zupanija', 'HR-03'),
(1025, 'HR', 'Splitsko-dalmatinska zupanija', 'HR-17'),
(1026, 'HR', 'Varazdinska zupanija', 'HR-05'),
(1027, 'HR', 'Viroviticko-podravska zupanija', 'HR-10'),
(1028, 'HR', 'Vukovarsko-srijemska zupanija', 'HR-16'),
(1029, 'HR', 'Zadarska zupanija', 'HR-13'),
(1030, 'HR', 'Zagrebacka zupanija', 'HR-01'),
(1031, 'HT', 'Artibonite', 'HT-AR'),
(1032, 'HT', 'Centre', 'HT-CE'),
(1033, 'HT', 'Nord', 'HT-ND'),
(1034, 'HT', 'Nord-Est', 'HT-NE'),
(1035, 'HT', 'Ouest', 'HT-OU'),
(1036, 'HT', 'Sud', 'HT-SD'),
(1037, 'HT', 'Sud-Est', 'HT-SE'),
(1038, 'HU', 'Bacs-Kiskun', 'HU-BK'),
(1039, 'HU', 'Baranya', 'HU-BA'),
(1040, 'HU', 'Bekes', 'HU-BE'),
(1041, 'HU', 'Borsod-Abauj-Zemplen', 'HU-BZ'),
(1042, 'HU', 'Budapest', 'HU-BU'),
(1043, 'HU', 'Csongrad', 'HU-CS'),
(1044, 'HU', 'Fejer', 'HU-FE'),
(1045, 'HU', 'Gyor-Moson-Sopron', 'HU-GS'),
(1046, 'HU', 'Hajdu-Bihar', 'HU-HB'),
(1047, 'HU', 'Heves', 'HU-HE'),
(1048, 'HU', 'Jasz-Nagykun-Szolnok', 'HU-JN'),
(1049, 'HU', 'Komarom-Esztergom', 'HU-KE'),
(1050, 'HU', 'Nograd', 'HU-NO'),
(1051, 'HU', 'Pest', 'HU-PE'),
(1052, 'HU', 'Somogy', 'HU-SO'),
(1053, 'HU', 'Szabolcs-Szatmar-Bereg', 'HU-SZ'),
(1054, 'HU', 'Tolna', 'HU-TO'),
(1055, 'HU', 'Vas', 'HU-VA'),
(1056, 'HU', 'Veszprem', 'HU-VE'),
(1057, 'HU', 'Zala', 'HU-ZA'),
(1058, 'ID', 'Aceh', 'ID-AC'),
(1059, 'ID', 'Bali', 'ID-BA'),
(1060, 'ID', 'Banten', 'ID-BT'),
(1061, 'ID', 'Bengkulu', 'ID-BE'),
(1062, 'ID', 'Gorontalo', 'ID-GO'),
(1063, 'ID', 'Jakarta Raya', 'ID-JK'),
(1064, 'ID', 'Jambi', 'ID-JA'),
(1065, 'ID', 'Jawa Barat', 'ID-JB'),
(1066, 'ID', 'Jawa Tengah', 'ID-JT'),
(1067, 'ID', 'Jawa Timur', 'ID-JI'),
(1068, 'ID', 'Kalimantan Barat', 'ID-KB'),
(1069, 'ID', 'Kalimantan Selatan', 'ID-KS'),
(1070, 'ID', 'Kalimantan Tengah', 'ID-KT'),
(1071, 'ID', 'Kalimantan Timur', 'ID-KI'),
(1072, 'ID', 'Kalimantan Utara', 'ID-KU'),
(1073, 'ID', 'Kepulauan Bangka Belitung', 'ID-BB'),
(1074, 'ID', 'Kepulauan Riau', 'ID-KR'),
(1075, 'ID', 'Lampung', 'ID-LA'),
(1076, 'ID', 'Maluku', 'ID-ML'),
(1077, 'ID', 'Maluku Utara', 'ID-MU'),
(1078, 'ID', 'Nusa Tenggara Barat', 'ID-NB'),
(1079, 'ID', 'Nusa Tenggara Timur', 'ID-NT'),
(1080, 'ID', 'Papua', 'ID-PP'),
(1081, 'ID', 'Papua Barat', 'ID-PB'),
(1082, 'ID', 'Riau', 'ID-RI'),
(1083, 'ID', 'Sulawesi Barat', 'ID-SR'),
(1084, 'ID', 'Sulawesi Selatan', 'ID-SN'),
(1085, 'ID', 'Sulawesi Tengah', 'ID-ST'),
(1086, 'ID', 'Sulawesi Tenggara', 'ID-SG'),
(1087, 'ID', 'Sulawesi Utara', 'ID-SA'),
(1088, 'ID', 'Sumatera Barat', 'ID-SB'),
(1089, 'ID', 'Sumatera Selatan', 'ID-SS'),
(1090, 'ID', 'Sumatera Utara', 'ID-SU'),
(1091, 'ID', 'Yogyakarta', 'ID-YO'),
(1092, 'IE', 'Carlow', 'IE-CW'),
(1093, 'IE', 'Cavan', 'IE-CN'),
(1094, 'IE', 'Clare', 'IE-CE'),
(1095, 'IE', 'Cork', 'IE-CO'),
(1096, 'IE', 'Donegal', 'IE-DL'),
(1097, 'IE', 'Dublin', 'IE-D'),
(1098, 'IE', 'Galway', 'IE-G'),
(1099, 'IE', 'Kerry', 'IE-KY'),
(1100, 'IE', 'Kildare', 'IE-KE'),
(1101, 'IE', 'Kilkenny', 'IE-KK'),
(1102, 'IE', 'Laois', 'IE-LS'),
(1103, 'IE', 'Leitrim', 'IE-LM'),
(1104, 'IE', 'Limerick', 'IE-LK'),
(1105, 'IE', 'Longford', 'IE-LD'),
(1106, 'IE', 'Louth', 'IE-LH'),
(1107, 'IE', 'Mayo', 'IE-MO'),
(1108, 'IE', 'Meath', 'IE-MH'),
(1109, 'IE', 'Monaghan', 'IE-MN'),
(1110, 'IE', 'Offaly', 'IE-OY'),
(1111, 'IE', 'Roscommon', 'IE-RN'),
(1112, 'IE', 'Sligo', 'IE-SO'),
(1113, 'IE', 'Tipperary', 'IE-TA'),
(1114, 'IE', 'Waterford', 'IE-WD'),
(1115, 'IE', 'Westmeath', 'IE-WH'),
(1116, 'IE', 'Wexford', 'IE-WX'),
(1117, 'IE', 'Wicklow', 'IE-WW'),
(1118, 'IL', 'HaDarom', 'IL-D'),
(1119, 'IL', 'HaMerkaz', 'IL-M'),
(1120, 'IL', 'HaTsafon', 'IL-Z'),
(1121, 'IL', 'Hefa', 'IL-HA'),
(1122, 'IL', 'Tel Aviv', 'IL-TA'),
(1123, 'IL', 'Yerushalayim', 'IL-JM'),
(1124, 'IM', 'Isle of Man', '-'),
(1125, 'IN', 'Andaman and Nicobar Islands', 'IN-AN'),
(1126, 'IN', 'Andhra Pradesh', 'IN-AP'),
(1127, 'IN', 'Arunachal Pradesh', 'IN-AR'),
(1128, 'IN', 'Assam', 'IN-AS'),
(1129, 'IN', 'Bihar', 'IN-BR'),
(1130, 'IN', 'Chandigarh', 'IN-CH'),
(1131, 'IN', 'Chhattisgarh', 'IN-CT'),
(1132, 'IN', 'Dadra and Nagar Haveli', 'IN-DN'),
(1133, 'IN', 'Dadra and Nagar Haveli and Daman and Diu', 'IN-DH'),
(1134, 'IN', 'Delhi', 'IN-DL'),
(1135, 'IN', 'Goa', 'IN-GA'),
(1136, 'IN', 'Gujarat', 'IN-GJ'),
(1137, 'IN', 'Haryana', 'IN-HR'),
(1138, 'IN', 'Himachal Pradesh', 'IN-HP'),
(1139, 'IN', 'Jammu and Kashmir', 'IN-JK'),
(1140, 'IN', 'Jharkhand', 'IN-JH'),
(1141, 'IN', 'Karnataka', 'IN-KA'),
(1142, 'IN', 'Kerala', 'IN-KL'),
(1143, 'IN', 'Lakshadweep', 'IN-LD'),
(1144, 'IN', 'Madhya Pradesh', 'IN-MP'),
(1145, 'IN', 'Maharashtra', 'IN-MH'),
(1146, 'IN', 'Manipur', 'IN-MN'),
(1147, 'IN', 'Meghalaya', 'IN-ML'),
(1148, 'IN', 'Mizoram', 'IN-MZ'),
(1149, 'IN', 'Nagaland', 'IN-NL'),
(1150, 'IN', 'Odisha', 'IN-OR'),
(1151, 'IN', 'Puducherry', 'IN-PY'),
(1152, 'IN', 'Punjab', 'IN-PB'),
(1153, 'IN', 'Rajasthan', 'IN-RJ'),
(1154, 'IN', 'Sikkim', 'IN-SK'),
(1155, 'IN', 'Tamil Nadu', 'IN-TN'),
(1156, 'IN', 'Telangana', 'IN-TG'),
(1157, 'IN', 'Tripura', 'IN-TR'),
(1158, 'IN', 'Uttar Pradesh', 'IN-UP'),
(1159, 'IN', 'Uttarakhand', 'IN-UT'),
(1160, 'IN', 'West Bengal', 'IN-WB'),
(1161, 'IO', 'British Indian Ocean Territory', '-'),
(1162, 'IQ', 'Al Anbar', 'IQ-AN'),
(1163, 'IQ', 'Al Basrah', 'IQ-BA'),
(1164, 'IQ', 'Al Muthanna', 'IQ-MU'),
(1165, 'IQ', 'Al Qadisiyah', 'IQ-QA'),
(1166, 'IQ', 'An Najaf', 'IQ-NA'),
(1167, 'IQ', 'Arbil', 'IQ-AR'),
(1168, 'IQ', 'As Sulaymaniyah', 'IQ-SU'),
(1169, 'IQ', 'Babil', 'IQ-BB'),
(1170, 'IQ', 'Baghdad', 'IQ-BG'),
(1171, 'IQ', 'Dahuk', 'IQ-DA'),
(1172, 'IQ', 'Dhi Qar', 'IQ-DQ'),
(1173, 'IQ', 'Diyala', 'IQ-DI'),
(1174, 'IQ', 'Karbala', 'IQ-KA'),
(1175, 'IQ', 'Kirkuk', 'IQ-KI'),
(1176, 'IQ', 'Maysan', 'IQ-MA'),
(1177, 'IQ', 'Ninawa', 'IQ-NI'),
(1178, 'IQ', 'Salah ad Din', 'IQ-SD'),
(1179, 'IQ', 'Wasit', 'IQ-WA'),
(1180, 'IR', 'Alborz', 'IR-30'),
(1181, 'IR', 'Ardabil', 'IR-24'),
(1182, 'IR', 'Azarbayjan-e Gharbi', 'IR-04'),
(1183, 'IR', 'Azarbayjan-e Sharqi', 'IR-03'),
(1184, 'IR', 'Bushehr', 'IR-18'),
(1185, 'IR', 'Chahar Mahal va Bakhtiari', 'IR-14'),
(1186, 'IR', 'Esfahan', 'IR-10'),
(1187, 'IR', 'Fars', 'IR-07'),
(1188, 'IR', 'Gilan', 'IR-01'),
(1189, 'IR', 'Golestan', 'IR-27'),
(1190, 'IR', 'Hamadan', 'IR-13'),
(1191, 'IR', 'Hormozgan', 'IR-22'),
(1192, 'IR', 'Ilam', 'IR-16'),
(1193, 'IR', 'Kerman', 'IR-08'),
(1194, 'IR', 'Kermanshah', 'IR-05'),
(1195, 'IR', 'Khorasan-e Jonubi', 'IR-29'),
(1196, 'IR', 'Khorasan-e Razavi', 'IR-09'),
(1197, 'IR', 'Khorasan-e Shomali', 'IR-28'),
(1198, 'IR', 'Khuzestan', 'IR-06'),
(1199, 'IR', 'Kohgiluyeh va Bowyer Ahmad', 'IR-17'),
(1200, 'IR', 'Kordestan', 'IR-12'),
(1201, 'IR', 'Lorestan', 'IR-15'),
(1202, 'IR', 'Markazi', 'IR-00'),
(1203, 'IR', 'Mazandaran', 'IR-02'),
(1204, 'IR', 'Qazvin', 'IR-26'),
(1205, 'IR', 'Qom', 'IR-25'),
(1206, 'IR', 'Semnan', 'IR-20'),
(1207, 'IR', 'Sistan va Baluchestan', 'IR-11'),
(1208, 'IR', 'Tehran', 'IR-23'),
(1209, 'IR', 'Yazd', 'IR-21'),
(1210, 'IR', 'Zanjan', 'IR-19'),
(1211, 'IS', 'Austurland', 'IS-7'),
(1212, 'IS', 'Hofudborgarsvaedi', 'IS-1'),
(1213, 'IS', 'Nordurland eystra', 'IS-6'),
(1214, 'IS', 'Nordurland vestra', 'IS-5'),
(1215, 'IS', 'Sudurland', 'IS-8'),
(1216, 'IS', 'Sudurnes', 'IS-2'),
(1217, 'IS', 'Vestfirdir', 'IS-4'),
(1218, 'IS', 'Vesturland', 'IS-3'),
(1219, 'IT', 'Abruzzo', 'IT-65'),
(1220, 'IT', 'Basilicata', 'IT-77'),
(1221, 'IT', 'Calabria', 'IT-78'),
(1222, 'IT', 'Campania', 'IT-72'),
(1223, 'IT', 'Emilia-Romagna', 'IT-45'),
(1224, 'IT', 'Friuli-Venezia Giulia', 'IT-36'),
(1225, 'IT', 'Lazio', 'IT-62'),
(1226, 'IT', 'Liguria', 'IT-42'),
(1227, 'IT', 'Lombardia', 'IT-25'),
(1228, 'IT', 'Marche', 'IT-57'),
(1229, 'IT', 'Molise', 'IT-67'),
(1230, 'IT', 'Piemonte', 'IT-21'),
(1231, 'IT', 'Puglia', 'IT-75'),
(1232, 'IT', 'Sardegna', 'IT-88'),
(1233, 'IT', 'Sicilia', 'IT-82'),
(1234, 'IT', 'Toscana', 'IT-52'),
(1235, 'IT', 'Trentino-Alto Adige', 'IT-32'),
(1236, 'IT', 'Umbria', 'IT-55'),
(1237, 'IT', 'Valle dAosta', 'IT-23'),
(1238, 'IT', 'Veneto', 'IT-34'),
(1239, 'JE', 'Jersey', '-'),
(1240, 'JM', 'Clarendon', 'JM-13'),
(1241, 'JM', 'Hanover', 'JM-09'),
(1242, 'JM', 'Kingston', 'JM-01'),
(1243, 'JM', 'Manchester', 'JM-12'),
(1244, 'JM', 'Portland', 'JM-04'),
(1245, 'JM', 'Saint Andrew', 'JM-02'),
(1246, 'JM', 'Saint Ann', 'JM-06'),
(1247, 'JM', 'Saint Catherine', 'JM-14'),
(1248, 'JM', 'Saint Elizabeth', 'JM-11'),
(1249, 'JM', 'Saint James', 'JM-08'),
(1250, 'JM', 'Saint Mary', 'JM-05'),
(1251, 'JM', 'Saint Thomas', 'JM-03'),
(1252, 'JM', 'Trelawny', 'JM-07'),
(1253, 'JM', 'Westmoreland', 'JM-10'),
(1254, 'JO', 'Ajlun', 'JO-AJ'),
(1255, 'JO', 'Al Aqabah', 'JO-AQ'),
(1256, 'JO', 'Al Asimah', 'JO-AM'),
(1257, 'JO', 'Al Balqa', 'JO-BA'),
(1258, 'JO', 'Al Karak', 'JO-KA'),
(1259, 'JO', 'Al Mafraq', 'JO-MA'),
(1260, 'JO', 'At Tafilah', 'JO-AT'),
(1261, 'JO', 'Az Zarqa', 'JO-AZ'),
(1262, 'JO', 'Irbid', 'JO-IR'),
(1263, 'JO', 'Jarash', 'JO-JA'),
(1264, 'JO', 'Maan', 'JO-MN'),
(1265, 'JO', 'Madaba', 'JO-MD'),
(1266, 'JP', 'Aichi', 'JP-23'),
(1267, 'JP', 'Akita', 'JP-05'),
(1268, 'JP', 'Aomori', 'JP-02'),
(1269, 'JP', 'Chiba', 'JP-12'),
(1270, 'JP', 'Ehime', 'JP-38'),
(1271, 'JP', 'Fukui', 'JP-18'),
(1272, 'JP', 'Fukuoka', 'JP-40'),
(1273, 'JP', 'Fukushima', 'JP-07'),
(1274, 'JP', 'Gifu', 'JP-21'),
(1275, 'JP', 'Gunma', 'JP-10'),
(1276, 'JP', 'Hiroshima', 'JP-34'),
(1277, 'JP', 'Hokkaido', 'JP-01'),
(1278, 'JP', 'Hyogo', 'JP-28'),
(1279, 'JP', 'Ibaraki', 'JP-08'),
(1280, 'JP', 'Ishikawa', 'JP-17'),
(1281, 'JP', 'Iwate', 'JP-03'),
(1282, 'JP', 'Kagawa', 'JP-37'),
(1283, 'JP', 'Kagoshima', 'JP-46'),
(1284, 'JP', 'Kanagawa', 'JP-14'),
(1285, 'JP', 'Kochi', 'JP-39'),
(1286, 'JP', 'Kumamoto', 'JP-43'),
(1287, 'JP', 'Kyoto', 'JP-26'),
(1288, 'JP', 'Mie', 'JP-24'),
(1289, 'JP', 'Miyagi', 'JP-04'),
(1290, 'JP', 'Miyazaki', 'JP-45'),
(1291, 'JP', 'Nagano', 'JP-20'),
(1292, 'JP', 'Nagasaki', 'JP-42'),
(1293, 'JP', 'Nara', 'JP-29'),
(1294, 'JP', 'Niigata', 'JP-15'),
(1295, 'JP', 'Oita', 'JP-44'),
(1296, 'JP', 'Okayama', 'JP-33'),
(1297, 'JP', 'Okinawa', 'JP-47'),
(1298, 'JP', 'Osaka', 'JP-27'),
(1299, 'JP', 'Saga', 'JP-41'),
(1300, 'JP', 'Saitama', 'JP-11'),
(1301, 'JP', 'Shiga', 'JP-25'),
(1302, 'JP', 'Shimane', 'JP-32'),
(1303, 'JP', 'Shizuoka', 'JP-22'),
(1304, 'JP', 'Tochigi', 'JP-09'),
(1305, 'JP', 'Tokushima', 'JP-36'),
(1306, 'JP', 'Tokyo', 'JP-13'),
(1307, 'JP', 'Tottori', 'JP-31'),
(1308, 'JP', 'Toyama', 'JP-16'),
(1309, 'JP', 'Wakayama', 'JP-30'),
(1310, 'JP', 'Yamagata', 'JP-06'),
(1311, 'JP', 'Yamaguchi', 'JP-35'),
(1312, 'JP', 'Yamanashi', 'JP-19'),
(1313, 'KE', 'Baringo', 'KE-01'),
(1314, 'KE', 'Bomet', 'KE-02'),
(1315, 'KE', 'Bungoma', 'KE-03'),
(1316, 'KE', 'Busia', 'KE-04'),
(1317, 'KE', 'Elgeyo/Marakwet', 'KE-05'),
(1318, 'KE', 'Embu', 'KE-06'),
(1319, 'KE', 'Garissa', 'KE-07'),
(1320, 'KE', 'Homa Bay', 'KE-08'),
(1321, 'KE', 'Isiolo', 'KE-09'),
(1322, 'KE', 'Kajiado', 'KE-10'),
(1323, 'KE', 'Kakamega', 'KE-11'),
(1324, 'KE', 'Kericho', 'KE-12'),
(1325, 'KE', 'Kiambu', 'KE-13'),
(1326, 'KE', 'Kilifi', 'KE-14'),
(1327, 'KE', 'Kirinyaga', 'KE-15'),
(1328, 'KE', 'Kisii', 'KE-16'),
(1329, 'KE', 'Kisumu', 'KE-17'),
(1330, 'KE', 'Kitui', 'KE-18'),
(1331, 'KE', 'Kwale', 'KE-19'),
(1332, 'KE', 'Laikipia', 'KE-20'),
(1333, 'KE', 'Lamu', 'KE-21'),
(1334, 'KE', 'Machakos', 'KE-22'),
(1335, 'KE', 'Makueni', 'KE-23'),
(1336, 'KE', 'Mandera', 'KE-24'),
(1337, 'KE', 'Marsabit', 'KE-25'),
(1338, 'KE', 'Meru', 'KE-26'),
(1339, 'KE', 'Migori', 'KE-27'),
(1340, 'KE', 'Mombasa', 'KE-28'),
(1341, 'KE', 'Muranga', 'KE-29'),
(1342, 'KE', 'Nairobi City', 'KE-30'),
(1343, 'KE', 'Nakuru', 'KE-31'),
(1344, 'KE', 'Nandi', 'KE-32'),
(1345, 'KE', 'Narok', 'KE-33'),
(1346, 'KE', 'Nyamira', 'KE-34'),
(1347, 'KE', 'Nyandarua', 'KE-35'),
(1348, 'KE', 'Nyeri', 'KE-36'),
(1349, 'KE', 'Siaya', 'KE-38'),
(1350, 'KE', 'Taita/Taveta', 'KE-39'),
(1351, 'KE', 'Tharaka-Nithi', 'KE-41'),
(1352, 'KE', 'Trans Nzoia', 'KE-42'),
(1353, 'KE', 'Turkana', 'KE-43'),
(1354, 'KE', 'Uasin Gishu', 'KE-44'),
(1355, 'KE', 'Wajir', 'KE-46'),
(1356, 'KG', 'Batken', 'KG-B'),
(1357, 'KG', 'Bishkek Shaary', 'KG-GB'),
(1358, 'KG', 'Chuy', 'KG-C'),
(1359, 'KG', 'Jalal-Abad', 'KG-J'),
(1360, 'KG', 'Naryn', 'KG-N'),
(1361, 'KG', 'Osh Shaary', 'KG-GO'),
(1362, 'KG', 'Talas', 'KG-T'),
(1363, 'KG', 'Ysyk-Kol', 'KG-Y'),
(1364, 'KH', 'Baat Dambang', 'KH-2'),
(1365, 'KH', 'Banteay Mean Choay', 'KH-1'),
(1366, 'KH', 'Kampong Chaam', 'KH-3'),
(1367, 'KH', 'Kampong Chhnang', 'KH-4'),
(1368, 'KH', 'Kampong Spueu', 'KH-5'),
(1369, 'KH', 'Kampong Thum', 'KH-6'),
(1370, 'KH', 'Kampot', 'KH-7'),
(1371, 'KH', 'Kandaal', 'KH-8'),
(1372, 'KH', 'Kaoh Kong', 'KH-9'),
(1373, 'KH', 'Kracheh', 'KH-10'),
(1374, 'KH', 'Krong Kaeb', 'KH-23'),
(1375, 'KH', 'Krong Pailin', 'KH-24'),
(1376, 'KH', 'Mondol Kiri', 'KH-11'),
(1377, 'KH', 'Phnom Penh', 'KH-12'),
(1378, 'KH', 'Pousaat', 'KH-15'),
(1379, 'KH', 'Preah Sihanouk', 'KH-18'),
(1380, 'KH', 'Prey Veaeng', 'KH-14'),
(1381, 'KH', 'Rotanak Kiri', 'KH-16'),
(1382, 'KH', 'Siem Reab', 'KH-17'),
(1383, 'KH', 'Stueng Traeng', 'KH-19'),
(1384, 'KH', 'Svaay Rieng', 'KH-20'),
(1385, 'KH', 'Taakaev', 'KH-21'),
(1386, 'KI', 'Gilbert Islands', 'KI-G'),
(1387, 'KM', 'Grande Comore', 'KM-G'),
(1388, 'KN', 'Saint Anne Sandy Point', 'KN-02'),
(1389, 'KN', 'Saint George Basseterre', 'KN-03'),
(1390, 'KN', 'Saint James Windward', 'KN-05'),
(1391, 'KN', 'Saint John Capisterre', 'KN-06'),
(1392, 'KN', 'Saint John Figtree', 'KN-07'),
(1393, 'KN', 'Saint Mary Cayon', 'KN-08'),
(1394, 'KN', 'Saint Paul Capisterre', 'KN-09'),
(1395, 'KN', 'Saint Paul Charlestown', 'KN-10'),
(1396, 'KN', 'Saint Peter Basseterre', 'KN-11'),
(1397, 'KN', 'Saint Thomas Lowland', 'KN-12'),
(1398, 'KN', 'Saint Thomas Middle Island', 'KN-13'),
(1399, 'KP', 'Pyongyang', 'KP-01'),
(1400, 'KR', 'Busan-gwangyeoksi', 'KR-26'),
(1401, 'KR', 'Chungcheongbuk-do', 'KR-43'),
(1402, 'KR', 'Chungcheongnam-do', 'KR-44'),
(1403, 'KR', 'Daegu-gwangyeoksi', 'KR-27'),
(1404, 'KR', 'Daejeon-gwangyeoksi', 'KR-30'),
(1405, 'KR', 'Gangwon-do', 'KR-42'),
(1406, 'KR', 'Gwangju-gwangyeoksi', 'KR-29'),
(1407, 'KR', 'Gyeonggi-do', 'KR-41'),
(1408, 'KR', 'Gyeongsangbuk-do', 'KR-47'),
(1409, 'KR', 'Gyeongsangnam-do', 'KR-48'),
(1410, 'KR', 'Incheon-gwangyeoksi', 'KR-28'),
(1411, 'KR', 'Jeju-teukbyeoljachido', 'KR-49'),
(1412, 'KR', 'Jeollabuk-do', 'KR-45'),
(1413, 'KR', 'Jeollanam-do', 'KR-46'),
(1414, 'KR', 'Seoul-teukbyeolsi', 'KR-11'),
(1415, 'KR', 'Ulsan-gwangyeoksi', 'KR-31'),
(1416, 'KW', 'Al Asimah', 'KW-KU'),
(1417, 'KW', 'Al Ahmadi', 'KW-AH'),
(1418, 'KW', 'Al Farwaniyah', 'KW-FA'),
(1419, 'KW', 'Al Jahra', 'KW-JA'),
(1420, 'KW', 'Hawalli', 'KW-HA'),
(1421, 'KW', 'Mubarak al Kabir', 'KW-MU'),
(1422, 'KY', 'Cayman Islands', '-'),
(1423, 'KZ', 'Almaty', 'KZ-ALA'),
(1424, 'KZ', 'Almaty oblysy', 'KZ-ALM'),
(1425, 'KZ', 'Aqmola oblysy', 'KZ-AKM'),
(1426, 'KZ', 'Aqtobe oblysy', 'KZ-AKT'),
(1427, 'KZ', 'Atyrau oblysy', 'KZ-ATY'),
(1428, 'KZ', 'Batys Qazaqstan oblysy', 'KZ-ZAP'),
(1429, 'KZ', 'Mangghystau oblysy', 'KZ-MAN'),
(1430, 'KZ', 'Nur-Sultan', 'KZ-AST'),
(1431, 'KZ', 'Ongtustik Qazaqstan oblysy', 'KZ-YUZ'),
(1432, 'KZ', 'Pavlodar oblysy', 'KZ-PAV'),
(1433, 'KZ', 'Qaraghandy oblysy', 'KZ-KAR'),
(1434, 'KZ', 'Qostanay oblysy', 'KZ-KUS'),
(1435, 'KZ', 'Qyzylorda oblysy', 'KZ-KZY'),
(1436, 'KZ', 'Shyghys Qazaqstan oblysy', 'KZ-VOS'),
(1437, 'KZ', 'Shymkent', 'KZ-SHY'),
(1438, 'KZ', 'Soltustik Qazaqstan oblysy', 'KZ-SEV'),
(1439, 'KZ', 'Zhambyl oblysy', 'KZ-ZHA'),
(1440, 'LA', 'Bolikhamxai', 'LA-BL'),
(1441, 'LA', 'Champasak', 'LA-CH'),
(1442, 'LA', 'Houaphan', 'LA-HO'),
(1443, 'LA', 'Khammouan', 'LA-KH'),
(1444, 'LA', 'Louangphabang', 'LA-LP'),
(1445, 'LA', 'Oudomxai', 'LA-OU'),
(1446, 'LA', 'Phongsali', 'LA-PH'),
(1447, 'LA', 'Savannakhet', 'LA-SV'),
(1448, 'LA', 'Viangchan', 'LA-VI'),
(1449, 'LA', 'Xaignabouli', 'LA-XA'),
(1450, 'LA', 'Xekong', 'LA-XE'),
(1451, 'LA', 'Xiangkhouang', 'LA-XI'),
(1452, 'LB', 'Aakkar', 'LB-AK'),
(1453, 'LB', 'Baalbek-Hermel', 'LB-BH'),
(1454, 'LB', 'Beqaa', 'LB-BI'),
(1455, 'LB', 'Beyrouth', 'LB-BA'),
(1456, 'LB', 'Liban-Nord', 'LB-AS'),
(1457, 'LB', 'Liban-Sud', 'LB-JA'),
(1458, 'LB', 'Mont-Liban', 'LB-JL'),
(1459, 'LB', 'Nabatiye', 'LB-NA'),
(1460, 'LC', 'Anse la Raye', 'LC-01'),
(1461, 'LC', 'Castries', 'LC-02'),
(1462, 'LC', 'Dennery', 'LC-05'),
(1463, 'LC', 'Gros Islet', 'LC-06'),
(1464, 'LC', 'Laborie', 'LC-07'),
(1465, 'LC', 'Soufriere', 'LC-10'),
(1466, 'LC', 'Vieux Fort', 'LC-11'),
(1467, 'LI', 'Balzers', 'LI-01');
INSERT INTO `rv_region` (`id`, `country_code`, `subdivision_name`, `code`) VALUES
(1468, 'LI', 'Eschen', 'LI-02'),
(1469, 'LI', 'Gamprin', 'LI-03'),
(1470, 'LI', 'Mauren', 'LI-04'),
(1471, 'LI', 'Planken', 'LI-05'),
(1472, 'LI', 'Ruggell', 'LI-06'),
(1473, 'LI', 'Schaan', 'LI-07'),
(1474, 'LI', 'Triesen', 'LI-09'),
(1475, 'LI', 'Triesenberg', 'LI-10'),
(1476, 'LI', 'Vaduz', 'LI-11'),
(1477, 'LK', 'Central Province', 'LK-2'),
(1478, 'LK', 'Eastern Province', 'LK-5'),
(1479, 'LK', 'North Central Province', 'LK-7'),
(1480, 'LK', 'North Western Province', 'LK-6'),
(1481, 'LK', 'Northern Province', 'LK-4'),
(1482, 'LK', 'Sabaragamuwa Province', 'LK-9'),
(1483, 'LK', 'Southern Province', 'LK-3'),
(1484, 'LK', 'Uva Province', 'LK-8'),
(1485, 'LK', 'Western Province', 'LK-1'),
(1486, 'LR', 'Bomi', 'LR-BM'),
(1487, 'LR', 'Grand Bassa', 'LR-GB'),
(1488, 'LR', 'Grand Gedeh', 'LR-GG'),
(1489, 'LR', 'Margibi', 'LR-MG'),
(1490, 'LR', 'Montserrado', 'LR-MO'),
(1491, 'LR', 'Sinoe', 'LR-SI'),
(1492, 'LS', 'Leribe', 'LS-C'),
(1493, 'LS', 'Mafeteng', 'LS-E'),
(1494, 'LS', 'Maseru', 'LS-A'),
(1495, 'LS', 'Mokhotlong', 'LS-J'),
(1496, 'LS', 'Quthing', 'LS-G'),
(1497, 'LS', 'Thaba-Tseka', 'LS-K'),
(1498, 'LT', 'Alytaus apskritis', 'LT-AL'),
(1499, 'LT', 'Kauno apskritis', 'LT-KU'),
(1500, 'LT', 'Klaipedos apskritis', 'LT-KL'),
(1501, 'LT', 'Marijampoles apskritis', 'LT-MR'),
(1502, 'LT', 'Panevezio apskritis', 'LT-PN'),
(1503, 'LT', 'Siauliu apskritis', 'LT-SA'),
(1504, 'LT', 'Taurages apskritis', 'LT-TA'),
(1505, 'LT', 'Telsiu apskritis', 'LT-TE'),
(1506, 'LT', 'Utenos apskritis', 'LT-UT'),
(1507, 'LT', 'Vilniaus apskritis', 'LT-VL'),
(1508, 'LU', 'Capellen', 'LU-CA'),
(1509, 'LU', 'Clervaux', 'LU-CL'),
(1510, 'LU', 'Diekirch', 'LU-DI'),
(1511, 'LU', 'Echternach', 'LU-EC'),
(1512, 'LU', 'Esch-sur-Alzette', 'LU-ES'),
(1513, 'LU', 'Grevenmacher', 'LU-GR'),
(1514, 'LU', 'Luxembourg', 'LU-LU'),
(1515, 'LU', 'Mersch', 'LU-ME'),
(1516, 'LU', 'Redange', 'LU-RD'),
(1517, 'LU', 'Remich', 'LU-RM'),
(1518, 'LU', 'Vianden', 'LU-VD'),
(1519, 'LU', 'Wiltz', 'LU-WI'),
(1520, 'LV', 'Adazu novads', 'LV-011'),
(1521, 'LV', 'Aglonas novads', 'LV-001'),
(1522, 'LV', 'Aizkraukles novads', 'LV-002'),
(1523, 'LV', 'Aizputes novads', 'LV-003'),
(1524, 'LV', 'Alojas novads', 'LV-005'),
(1525, 'LV', 'Aluksnes novads', 'LV-007'),
(1526, 'LV', 'Auces novads', 'LV-010'),
(1527, 'LV', 'Babites novads', 'LV-012'),
(1528, 'LV', 'Baldones novads', 'LV-013'),
(1529, 'LV', 'Balvu novads', 'LV-015'),
(1530, 'LV', 'Bauskas novads', 'LV-016'),
(1531, 'LV', 'Beverinas novads', 'LV-017'),
(1532, 'LV', 'Brocenu novads', 'LV-018'),
(1533, 'LV', 'Carnikavas novads', 'LV-020'),
(1534, 'LV', 'Cesu novads', 'LV-022'),
(1535, 'LV', 'Cesvaines novads', 'LV-021'),
(1536, 'LV', 'Dagdas novads', 'LV-024'),
(1537, 'LV', 'Daugavpils novads', 'LV-025'),
(1538, 'LV', 'Dobeles novads', 'LV-026'),
(1539, 'LV', 'Dundagas novads', 'LV-027'),
(1540, 'LV', 'Engures novads', 'LV-029'),
(1541, 'LV', 'Erglu novads', 'LV-030'),
(1542, 'LV', 'Gulbenes novads', 'LV-033'),
(1543, 'LV', 'Iecavas novads', 'LV-034'),
(1544, 'LV', 'Ikskiles novads', 'LV-035'),
(1545, 'LV', 'Incukalna novads', 'LV-037'),
(1546, 'LV', 'Jaunjelgavas novads', 'LV-038'),
(1547, 'LV', 'Jaunpiebalgas novads', 'LV-039'),
(1548, 'LV', 'Jaunpils novads', 'LV-040'),
(1549, 'LV', 'Jekabpils novads', 'LV-042'),
(1550, 'LV', 'Jelgava', 'LV-JEL'),
(1551, 'LV', 'Jelgavas novads', 'LV-041'),
(1552, 'LV', 'Jurmala', 'LV-JUR'),
(1553, 'LV', 'Kandavas novads', 'LV-043'),
(1554, 'LV', 'Kekavas novads', 'LV-052'),
(1555, 'LV', 'Kokneses novads', 'LV-046'),
(1556, 'LV', 'Kraslavas novads', 'LV-047'),
(1557, 'LV', 'Kuldigas novads', 'LV-050'),
(1558, 'LV', 'Lielvardes novads', 'LV-053'),
(1559, 'LV', 'Liepaja', 'LV-LPX'),
(1560, 'LV', 'Limbazu novads', 'LV-054'),
(1561, 'LV', 'Livanu novads', 'LV-056'),
(1562, 'LV', 'Lubanas novads', 'LV-057'),
(1563, 'LV', 'Ludzas novads', 'LV-058'),
(1564, 'LV', 'Madonas novads', 'LV-059'),
(1565, 'LV', 'Malpils novads', 'LV-061'),
(1566, 'LV', 'Nauksenu novads', 'LV-064'),
(1567, 'LV', 'Ogres novads', 'LV-067'),
(1568, 'LV', 'Olaines novads', 'LV-068'),
(1569, 'LV', 'Ozolnieku novads', 'LV-069'),
(1570, 'LV', 'Preilu novads', 'LV-073'),
(1571, 'LV', 'Priekules novads', 'LV-075'),
(1572, 'LV', 'Rezeknes novads', 'LV-077'),
(1573, 'LV', 'Riebinu novads', 'LV-078'),
(1574, 'LV', 'Riga', 'LV-RIX'),
(1575, 'LV', 'Ropazu novads', 'LV-080'),
(1576, 'LV', 'Rundales novads', 'LV-083'),
(1577, 'LV', 'Salaspils novads', 'LV-087'),
(1578, 'LV', 'Saldus novads', 'LV-088'),
(1579, 'LV', 'Saulkrastu novads', 'LV-089'),
(1580, 'LV', 'Sejas novads', 'LV-090'),
(1581, 'LV', 'Siguldas novads', 'LV-091'),
(1582, 'LV', 'Skrundas novads', 'LV-093'),
(1583, 'LV', 'Smiltenes novads', 'LV-094'),
(1584, 'LV', 'Stopinu novads', 'LV-095'),
(1585, 'LV', 'Talsu novads', 'LV-097'),
(1586, 'LV', 'Tukuma novads', 'LV-099'),
(1587, 'LV', 'Vainodes novads', 'LV-100'),
(1588, 'LV', 'Valkas novads', 'LV-101'),
(1589, 'LV', 'Valmiera', 'LV-VMR'),
(1590, 'LV', 'Varkavas novads', 'LV-103'),
(1591, 'LV', 'Vecumnieku novads', 'LV-105'),
(1592, 'LV', 'Ventspils novads', 'LV-106'),
(1593, 'LV', 'Zilupes novads', 'LV-110'),
(1594, 'LY', 'Al Butnan', 'LY-BU'),
(1595, 'LY', 'Al Jabal al Akhdar', 'LY-JA'),
(1596, 'LY', 'Al Jabal al Gharbi', 'LY-JG'),
(1597, 'LY', 'Al Jafarah', 'LY-JI'),
(1598, 'LY', 'Al Jufrah', 'LY-JU'),
(1599, 'LY', 'Al Marj', 'LY-MJ'),
(1600, 'LY', 'Al Marqab', 'LY-MB'),
(1601, 'LY', 'Al Wahat', 'LY-WA'),
(1602, 'LY', 'An Nuqat al Khams', 'LY-NQ'),
(1603, 'LY', 'Az Zawiyah', 'LY-ZA'),
(1604, 'LY', 'Banghazi', 'LY-BA'),
(1605, 'LY', 'Darnah', 'LY-DR'),
(1606, 'LY', 'Misratah', 'LY-MI'),
(1607, 'LY', 'Murzuq', 'LY-MQ'),
(1608, 'LY', 'Nalut', 'LY-NL'),
(1609, 'LY', 'Sabha', 'LY-SB'),
(1610, 'LY', 'Surt', 'LY-SR'),
(1611, 'LY', 'Tarabulus', 'LY-TB'),
(1612, 'MA', 'Beni-Mellal-Khenifra', 'MA-05'),
(1613, 'MA', 'Casablanca-Settat', 'MA-06'),
(1614, 'MA', 'Draa-Tafilalet', 'MA-08'),
(1615, 'MA', 'Fes- Meknes', 'MA-03'),
(1616, 'MA', 'Guelmim-Oued Noun (EH-partial)', 'MA-10'),
(1617, 'MA', 'LOriental', 'MA-02'),
(1618, 'MA', 'Laayoune-Sakia El Hamra (EH-partial)', 'MA-11'),
(1619, 'MA', 'Marrakech-Safi', 'MA-07'),
(1620, 'MA', 'Rabat-Sale-Kenitra', 'MA-04'),
(1621, 'MA', 'Souss-Massa', 'MA-09'),
(1622, 'MA', 'Tanger-Tetouan-Al Hoceima', 'MA-01'),
(1623, 'MC', 'Fontvieille', 'MC-FO'),
(1624, 'MC', 'La Condamine', 'MC-CO'),
(1625, 'MC', 'Monaco-Ville', 'MC-MO'),
(1626, 'MC', 'Monte-Carlo', 'MC-MC'),
(1627, 'MC', 'Saint-Roman', 'MC-SR'),
(1628, 'MD', 'Anenii Noi', 'MD-AN'),
(1629, 'MD', 'Balti', 'MD-BA'),
(1630, 'MD', 'Basarabeasca', 'MD-BS'),
(1631, 'MD', 'Bender', 'MD-BD'),
(1632, 'MD', 'Briceni', 'MD-BR'),
(1633, 'MD', 'Cahul', 'MD-CA'),
(1634, 'MD', 'Calarasi', 'MD-CL'),
(1635, 'MD', 'Cantemir', 'MD-CT'),
(1636, 'MD', 'Causeni', 'MD-CS'),
(1637, 'MD', 'Chisinau', 'MD-CU'),
(1638, 'MD', 'Cimislia', 'MD-CM'),
(1639, 'MD', 'Criuleni', 'MD-CR'),
(1640, 'MD', 'Donduseni', 'MD-DO'),
(1641, 'MD', 'Drochia', 'MD-DR'),
(1642, 'MD', 'Dubasari', 'MD-DU'),
(1643, 'MD', 'Edinet', 'MD-ED'),
(1644, 'MD', 'Falesti', 'MD-FA'),
(1645, 'MD', 'Floresti', 'MD-FL'),
(1646, 'MD', 'Gagauzia, Unitatea teritoriala autonoma', 'MD-GA'),
(1647, 'MD', 'Glodeni', 'MD-GL'),
(1648, 'MD', 'Hincesti', 'MD-HI'),
(1649, 'MD', 'Ialoveni', 'MD-IA'),
(1650, 'MD', 'Leova', 'MD-LE'),
(1651, 'MD', 'Nisporeni', 'MD-NI'),
(1652, 'MD', 'Ocnita', 'MD-OC'),
(1653, 'MD', 'Orhei', 'MD-OR'),
(1654, 'MD', 'Rezina', 'MD-RE'),
(1655, 'MD', 'Riscani', 'MD-RI'),
(1656, 'MD', 'Singerei', 'MD-SI'),
(1657, 'MD', 'Soldanesti', 'MD-SD'),
(1658, 'MD', 'Soroca', 'MD-SO'),
(1659, 'MD', 'Stefan Voda', 'MD-SV'),
(1660, 'MD', 'Stinga Nistrului, unitatea teritoriala din', 'MD-SN'),
(1661, 'MD', 'Straseni', 'MD-ST'),
(1662, 'MD', 'Taraclia', 'MD-TA'),
(1663, 'MD', 'Telenesti', 'MD-TE'),
(1664, 'MD', 'Ungheni', 'MD-UN'),
(1665, 'ME', 'Bar', 'ME-02'),
(1666, 'ME', 'Berane', 'ME-03'),
(1667, 'ME', 'Bijelo Polje', 'ME-04'),
(1668, 'ME', 'Budva', 'ME-05'),
(1669, 'ME', 'Cetinje', 'ME-06'),
(1670, 'ME', 'Danilovgrad', 'ME-07'),
(1671, 'ME', 'Herceg-Novi', 'ME-08'),
(1672, 'ME', 'Kolasin', 'ME-09'),
(1673, 'ME', 'Kotor', 'ME-10'),
(1674, 'ME', 'Niksic', 'ME-12'),
(1675, 'ME', 'Plav', 'ME-13'),
(1676, 'ME', 'Pljevlja', 'ME-14'),
(1677, 'ME', 'Pluzine', 'ME-15'),
(1678, 'ME', 'Podgorica', 'ME-16'),
(1679, 'ME', 'Rozaje', 'ME-17'),
(1680, 'ME', 'Tivat', 'ME-19'),
(1681, 'ME', 'Tuzi', 'ME-24'),
(1682, 'ME', 'Ulcinj', 'ME-20'),
(1683, 'ME', 'Zabljak', 'ME-21'),
(1684, 'MF', 'Saint Martin (French Part)', '-'),
(1685, 'MG', 'Antananarivo', 'MG-T'),
(1686, 'MG', 'Antsiranana', 'MG-D'),
(1687, 'MG', 'Fianarantsoa', 'MG-F'),
(1688, 'MG', 'Mahajanga', 'MG-M'),
(1689, 'MG', 'Toamasina', 'MG-A'),
(1690, 'MG', 'Toliara', 'MG-U'),
(1691, 'MH', 'Kwajalein', 'MH-KWA'),
(1692, 'MH', 'Majuro', 'MH-MAJ'),
(1693, 'MK', 'Aracinovo', 'MK-802'),
(1694, 'MK', 'Berovo', 'MK-201'),
(1695, 'MK', 'Bitola', 'MK-501'),
(1696, 'MK', 'Bogdanci', 'MK-401'),
(1697, 'MK', 'Bogovinje', 'MK-601'),
(1698, 'MK', 'Bosilovo', 'MK-402'),
(1699, 'MK', 'Brvenica', 'MK-602'),
(1700, 'MK', 'Butel', 'MK-803'),
(1701, 'MK', 'Caska', 'MK-109'),
(1702, 'MK', 'Centar', 'MK-814'),
(1703, 'MK', 'Centar Zupa', 'MK-313'),
(1704, 'MK', 'Cesinovo-Oblesevo', 'MK-210'),
(1705, 'MK', 'Cucer Sandevo', 'MK-816'),
(1706, 'MK', 'Debar', 'MK-303'),
(1707, 'MK', 'Delcevo', 'MK-203'),
(1708, 'MK', 'Dojran', 'MK-406'),
(1709, 'MK', 'Dolneni', 'MK-503'),
(1710, 'MK', 'Gazi Baba', 'MK-804'),
(1711, 'MK', 'Gevgelija', 'MK-405'),
(1712, 'MK', 'Gostivar', 'MK-604'),
(1713, 'MK', 'Ilinden', 'MK-807'),
(1714, 'MK', 'Jegunovce', 'MK-606'),
(1715, 'MK', 'Karbinci', 'MK-205'),
(1716, 'MK', 'Kavadarci', 'MK-104'),
(1717, 'MK', 'Kicevo', 'MK-307'),
(1718, 'MK', 'Kisela Voda', 'MK-809'),
(1719, 'MK', 'Kocani', 'MK-206'),
(1720, 'MK', 'Kratovo', 'MK-701'),
(1721, 'MK', 'Kriva Palanka', 'MK-702'),
(1722, 'MK', 'Krusevo', 'MK-505'),
(1723, 'MK', 'Kumanovo', 'MK-703'),
(1724, 'MK', 'Lipkovo', 'MK-704'),
(1725, 'MK', 'Makedonska Kamenica', 'MK-207'),
(1726, 'MK', 'Mavrovo i Rostusa', 'MK-607'),
(1727, 'MK', 'Mogila', 'MK-506'),
(1728, 'MK', 'Negotino', 'MK-106'),
(1729, 'MK', 'Novaci', 'MK-507'),
(1730, 'MK', 'Novo Selo', 'MK-408'),
(1731, 'MK', 'Ohrid', 'MK-310'),
(1732, 'MK', 'Pehcevo', 'MK-208'),
(1733, 'MK', 'Petrovec', 'MK-810'),
(1734, 'MK', 'Plasnica', 'MK-311'),
(1735, 'MK', 'Prilep', 'MK-508'),
(1736, 'MK', 'Probistip', 'MK-209'),
(1737, 'MK', 'Radovis', 'MK-409'),
(1738, 'MK', 'Rankovce', 'MK-705'),
(1739, 'MK', 'Resen', 'MK-509'),
(1740, 'MK', 'Rosoman', 'MK-107'),
(1741, 'MK', 'Saraj', 'MK-811'),
(1742, 'MK', 'Sopiste', 'MK-812'),
(1743, 'MK', 'Stip', 'MK-211'),
(1744, 'MK', 'Struga', 'MK-312'),
(1745, 'MK', 'Strumica', 'MK-410'),
(1746, 'MK', 'Studenicani', 'MK-813'),
(1747, 'MK', 'Suto Orizari', 'MK-817'),
(1748, 'MK', 'Sveti Nikole', 'MK-108'),
(1749, 'MK', 'Tearce', 'MK-608'),
(1750, 'MK', 'Tetovo', 'MK-609'),
(1751, 'MK', 'Valandovo', 'MK-403'),
(1752, 'MK', 'Vasilevo', 'MK-404'),
(1753, 'MK', 'Veles', 'MK-101'),
(1754, 'MK', 'Vinica', 'MK-202'),
(1755, 'MK', 'Vrapciste', 'MK-603'),
(1756, 'MK', 'Zelenikovo', 'MK-806'),
(1757, 'MK', 'Zelino', 'MK-605'),
(1758, 'ML', 'Bamako', 'ML-BKO'),
(1759, 'ML', 'Gao', 'ML-7'),
(1760, 'ML', 'Kayes', 'ML-1'),
(1761, 'ML', 'Kidal', 'ML-8'),
(1762, 'ML', 'Koulikoro', 'ML-2'),
(1763, 'ML', 'Mopti', 'ML-5'),
(1764, 'ML', 'Segou', 'ML-4'),
(1765, 'ML', 'Sikasso', 'ML-3'),
(1766, 'ML', 'Tombouctou', 'ML-6'),
(1767, 'MM', 'Ayeyarwady', 'MM-07'),
(1768, 'MM', 'Bago', 'MM-02'),
(1769, 'MM', 'Chin', 'MM-14'),
(1770, 'MM', 'Kachin', 'MM-11'),
(1771, 'MM', 'Kayah', 'MM-12'),
(1772, 'MM', 'Kayin', 'MM-13'),
(1773, 'MM', 'Magway', 'MM-03'),
(1774, 'MM', 'Mandalay', 'MM-04'),
(1775, 'MM', 'Mon', 'MM-15'),
(1776, 'MM', 'Nay Pyi Taw', 'MM-18'),
(1777, 'MM', 'Rakhine', 'MM-16'),
(1778, 'MM', 'Sagaing', 'MM-01'),
(1779, 'MM', 'Shan', 'MM-17'),
(1780, 'MM', 'Tanintharyi', 'MM-05'),
(1781, 'MM', 'Yangon', 'MM-06'),
(1782, 'MN', 'Bayan-Olgiy', 'MN-071'),
(1783, 'MN', 'Darhan uul', 'MN-037'),
(1784, 'MN', 'Dornod', 'MN-061'),
(1785, 'MN', 'Govi-Altay', 'MN-065'),
(1786, 'MN', 'Hovd', 'MN-043'),
(1787, 'MN', 'Omnogovi', 'MN-053'),
(1788, 'MN', 'Orhon', 'MN-035'),
(1789, 'MN', 'Selenge', 'MN-049'),
(1790, 'MN', 'Tov', 'MN-047'),
(1791, 'MN', 'Ulaanbaatar', 'MN-1'),
(1792, 'MO', 'Macao', '-'),
(1793, 'MP', 'Northern Mariana Islands', '-'),
(1794, 'MQ', 'Martinique', '-'),
(1795, 'MR', 'Dakhlet Nouadhibou', 'MR-08'),
(1796, 'MR', 'Gorgol', 'MR-04'),
(1797, 'MR', 'Inchiri', 'MR-12'),
(1798, 'MR', 'Nouakchott Ouest', 'MR-13'),
(1799, 'MR', 'Tiris Zemmour', 'MR-11'),
(1800, 'MR', 'Trarza', 'MR-06'),
(1801, 'MS', 'Saint Anthony', '-'),
(1802, 'MS', 'Saint Peter', '-'),
(1803, 'MT', 'Attard', 'MT-01'),
(1804, 'MT', 'Balzan', 'MT-02'),
(1805, 'MT', 'Birgu', 'MT-03'),
(1806, 'MT', 'Birkirkara', 'MT-04'),
(1807, 'MT', 'Birzebbuga', 'MT-05'),
(1808, 'MT', 'Bormla', 'MT-06'),
(1809, 'MT', 'Dingli', 'MT-07'),
(1810, 'MT', 'Fgura', 'MT-08'),
(1811, 'MT', 'Floriana', 'MT-09'),
(1812, 'MT', 'Fontana', 'MT-10'),
(1813, 'MT', 'Gharb', 'MT-14'),
(1814, 'MT', 'Gharghur', 'MT-15'),
(1815, 'MT', 'Ghasri', 'MT-16'),
(1816, 'MT', 'Ghaxaq', 'MT-17'),
(1817, 'MT', 'Gudja', 'MT-11'),
(1818, 'MT', 'Gzira', 'MT-12'),
(1819, 'MT', 'Hamrun', 'MT-18'),
(1820, 'MT', 'Iklin', 'MT-19'),
(1821, 'MT', 'Isla', 'MT-20'),
(1822, 'MT', 'Kalkara', 'MT-21'),
(1823, 'MT', 'Kercem', 'MT-22'),
(1824, 'MT', 'Kirkop', 'MT-23'),
(1825, 'MT', 'Lija', 'MT-24'),
(1826, 'MT', 'Luqa', 'MT-25'),
(1827, 'MT', 'Marsa', 'MT-26'),
(1828, 'MT', 'Marsaskala', 'MT-27'),
(1829, 'MT', 'Marsaxlokk', 'MT-28'),
(1830, 'MT', 'Mdina', 'MT-29'),
(1831, 'MT', 'Mellieha', 'MT-30'),
(1832, 'MT', 'Mgarr', 'MT-31'),
(1833, 'MT', 'Mosta', 'MT-32'),
(1834, 'MT', 'Mqabba', 'MT-33'),
(1835, 'MT', 'Msida', 'MT-34'),
(1836, 'MT', 'Mtarfa', 'MT-35'),
(1837, 'MT', 'Munxar', 'MT-36'),
(1838, 'MT', 'Nadur', 'MT-37'),
(1839, 'MT', 'Naxxar', 'MT-38'),
(1840, 'MT', 'Paola', 'MT-39'),
(1841, 'MT', 'Pembroke', 'MT-40'),
(1842, 'MT', 'Pieta', 'MT-41'),
(1843, 'MT', 'Qala', 'MT-42'),
(1844, 'MT', 'Qormi', 'MT-43'),
(1845, 'MT', 'Rabat Gozo', 'MT-45'),
(1846, 'MT', 'Rabat Malta', 'MT-46'),
(1847, 'MT', 'Safi', 'MT-47'),
(1848, 'MT', 'Saint John', 'MT-49'),
(1849, 'MT', 'Saint Julians', 'MT-48'),
(1850, 'MT', 'Saint Lucias', 'MT-53'),
(1851, 'MT', 'Saint Pauls Bay', 'MT-51'),
(1852, 'MT', 'Sannat', 'MT-52'),
(1853, 'MT', 'Santa Venera', 'MT-54'),
(1854, 'MT', 'Siggiewi', 'MT-55'),
(1855, 'MT', 'Sliema', 'MT-56'),
(1856, 'MT', 'Swieqi', 'MT-57'),
(1857, 'MT', 'Ta Xbiex', 'MT-58'),
(1858, 'MT', 'Tarxien', 'MT-59'),
(1859, 'MT', 'Valletta', 'MT-60'),
(1860, 'MT', 'Xaghra', 'MT-61'),
(1861, 'MT', 'Xewkija', 'MT-62'),
(1862, 'MT', 'Xghajra', 'MT-63'),
(1863, 'MT', 'Zabbar', 'MT-64'),
(1864, 'MT', 'Zebbug Gozo', 'MT-65'),
(1865, 'MT', 'Zejtun', 'MT-67'),
(1866, 'MT', 'Zurrieq', 'MT-68'),
(1867, 'MU', 'Black River', 'MU-BL'),
(1868, 'MU', 'Flacq', 'MU-FL'),
(1869, 'MU', 'Grand Port', 'MU-GP'),
(1870, 'MU', 'Moka', 'MU-MO'),
(1871, 'MU', 'Pamplemousses', 'MU-PA'),
(1872, 'MU', 'Plaines Wilhems', 'MU-PW'),
(1873, 'MU', 'Port Louis', 'MU-PL'),
(1874, 'MU', 'Riviere du Rempart', 'MU-RR'),
(1875, 'MU', 'Rodrigues Islands', 'MU-RO'),
(1876, 'MU', 'Savanne', 'MU-SA'),
(1877, 'MV', 'Addu City', 'MV-01'),
(1878, 'MV', 'Faadhippolhu', 'MV-03'),
(1879, 'MV', 'Felidhu Atoll', 'MV-04'),
(1880, 'MV', 'Hahdhunmathi', 'MV-05'),
(1881, 'MV', 'Male', 'MV-MLE'),
(1882, 'MV', 'Mulaku Atoll', 'MV-12'),
(1883, 'MV', 'North Maalhosmadulu', 'MV-13'),
(1884, 'MV', 'North Thiladhunmathi', 'MV-07'),
(1885, 'MV', 'South Ari Atoll', 'MV-00'),
(1886, 'MV', 'South Huvadhu Atoll', 'MV-28'),
(1887, 'MV', 'South Maalhosmadulu', 'MV-20'),
(1888, 'MV', 'South Miladhunmadulu', 'MV-25'),
(1889, 'MV', 'South Nilandhe Atoll', 'MV-17'),
(1890, 'MV', 'South Thiladhunmathi', 'MV-23'),
(1891, 'MW', 'Balaka', 'MW-BA'),
(1892, 'MW', 'Blantyre', 'MW-BL'),
(1893, 'MW', 'Chiradzulu', 'MW-CR'),
(1894, 'MW', 'Dedza', 'MW-DE'),
(1895, 'MW', 'Dowa', 'MW-DO'),
(1896, 'MW', 'Karonga', 'MW-KR'),
(1897, 'MW', 'Lilongwe', 'MW-LI'),
(1898, 'MW', 'Machinga', 'MW-MH'),
(1899, 'MW', 'Mangochi', 'MW-MG'),
(1900, 'MW', 'Mchinji', 'MW-MC'),
(1901, 'MW', 'Mzimba', 'MW-MZ'),
(1902, 'MW', 'Nkhotakota', 'MW-NK'),
(1903, 'MW', 'Salima', 'MW-SA'),
(1904, 'MW', 'Zomba', 'MW-ZO'),
(1905, 'MX', 'Aguascalientes', 'MX-AGU'),
(1906, 'MX', 'Baja California', 'MX-BCN'),
(1907, 'MX', 'Baja California Sur', 'MX-BCS'),
(1908, 'MX', 'Campeche', 'MX-CAM'),
(1909, 'MX', 'Chiapas', 'MX-CHP'),
(1910, 'MX', 'Chihuahua', 'MX-CHH'),
(1911, 'MX', 'Ciudad de Mexico', 'MX-CMX'),
(1912, 'MX', 'Coahuila de Zaragoza', 'MX-COA'),
(1913, 'MX', 'Colima', 'MX-COL'),
(1914, 'MX', 'Durango', 'MX-DUR'),
(1915, 'MX', 'Guanajuato', 'MX-GUA'),
(1916, 'MX', 'Guerrero', 'MX-GRO'),
(1917, 'MX', 'Hidalgo', 'MX-HID'),
(1918, 'MX', 'Jalisco', 'MX-JAL'),
(1919, 'MX', 'Mexico', 'MX-MEX'),
(1920, 'MX', 'Michoacan de Ocampo', 'MX-MIC'),
(1921, 'MX', 'Morelos', 'MX-MOR'),
(1922, 'MX', 'Nayarit', 'MX-NAY'),
(1923, 'MX', 'Nuevo Leon', 'MX-NLE'),
(1924, 'MX', 'Oaxaca', 'MX-OAX'),
(1925, 'MX', 'Puebla', 'MX-PUE'),
(1926, 'MX', 'Queretaro', 'MX-QUE'),
(1927, 'MX', 'Quintana Roo', 'MX-ROO'),
(1928, 'MX', 'San Luis Potosi', 'MX-SLP'),
(1929, 'MX', 'Sinaloa', 'MX-SIN'),
(1930, 'MX', 'Sonora', 'MX-SON'),
(1931, 'MX', 'Tabasco', 'MX-TAB'),
(1932, 'MX', 'Tamaulipas', 'MX-TAM'),
(1933, 'MX', 'Tlaxcala', 'MX-TLA'),
(1934, 'MX', 'Veracruz de Ignacio de la Llave', 'MX-VER'),
(1935, 'MX', 'Yucatan', 'MX-YUC'),
(1936, 'MX', 'Zacatecas', 'MX-ZAC'),
(1937, 'MY', 'Johor', 'MY-01'),
(1938, 'MY', 'Kedah', 'MY-02'),
(1939, 'MY', 'Kelantan', 'MY-03'),
(1940, 'MY', 'Melaka', 'MY-04'),
(1941, 'MY', 'Negeri Sembilan', 'MY-05'),
(1942, 'MY', 'Pahang', 'MY-06'),
(1943, 'MY', 'Perak', 'MY-08'),
(1944, 'MY', 'Perlis', 'MY-09'),
(1945, 'MY', 'Pulau Pinang', 'MY-07'),
(1946, 'MY', 'Sabah', 'MY-12'),
(1947, 'MY', 'Sarawak', 'MY-13'),
(1948, 'MY', 'Selangor', 'MY-10'),
(1949, 'MY', 'Terengganu', 'MY-11'),
(1950, 'MY', 'Wilayah Persekutuan Kuala Lumpur', 'MY-14'),
(1951, 'MY', 'Wilayah Persekutuan Labuan', 'MY-15'),
(1952, 'MY', 'Wilayah Persekutuan Putrajaya', 'MY-16'),
(1953, 'MZ', 'Cabo Delgado', 'MZ-P'),
(1954, 'MZ', 'Gaza', 'MZ-G'),
(1955, 'MZ', 'Inhambane', 'MZ-I'),
(1956, 'MZ', 'Manica', 'MZ-B'),
(1957, 'MZ', 'Maputo', 'MZ-L'),
(1958, 'MZ', 'Nampula', 'MZ-N'),
(1959, 'MZ', 'Niassa', 'MZ-A'),
(1960, 'MZ', 'Sofala', 'MZ-S'),
(1961, 'MZ', 'Tete', 'MZ-T'),
(1962, 'MZ', 'Zambezia', 'MZ-Q'),
(1963, 'NA', 'Erongo', 'NA-ER'),
(1964, 'NA', 'Hardap', 'NA-HA'),
(1965, 'NA', 'Karas', 'NA-KA'),
(1966, 'NA', 'Kavango East', 'NA-KE'),
(1967, 'NA', 'Khomas', 'NA-KH'),
(1968, 'NA', 'Kunene', 'NA-KU'),
(1969, 'NA', 'Ohangwena', 'NA-OW'),
(1970, 'NA', 'Omaheke', 'NA-OH'),
(1971, 'NA', 'Omusati', 'NA-OS'),
(1972, 'NA', 'Oshana', 'NA-ON'),
(1973, 'NA', 'Oshikoto', 'NA-OT'),
(1974, 'NA', 'Otjozondjupa', 'NA-OD'),
(1975, 'NA', 'Zambezi', 'NA-CA'),
(1976, 'NC', 'Province Nord', '-'),
(1977, 'NC', 'Province Sud', '-'),
(1978, 'NE', 'Agadez', 'NE-1'),
(1979, 'NE', 'Diffa', 'NE-2'),
(1980, 'NE', 'Dosso', 'NE-3'),
(1981, 'NE', 'Niamey', 'NE-8'),
(1982, 'NE', 'Tahoua', 'NE-5'),
(1983, 'NE', 'Zinder', 'NE-7'),
(1984, 'NF', 'Norfolk Island', '-'),
(1985, 'NG', 'Abia', 'NG-AB'),
(1986, 'NG', 'Abuja Federal Capital Territory', 'NG-FC'),
(1987, 'NG', 'Adamawa', 'NG-AD'),
(1988, 'NG', 'Akwa Ibom', 'NG-AK'),
(1989, 'NG', 'Anambra', 'NG-AN'),
(1990, 'NG', 'Bauchi', 'NG-BA'),
(1991, 'NG', 'Bayelsa', 'NG-BY'),
(1992, 'NG', 'Benue', 'NG-BE'),
(1993, 'NG', 'Borno', 'NG-BO'),
(1994, 'NG', 'Cross River', 'NG-CR'),
(1995, 'NG', 'Delta', 'NG-DE'),
(1996, 'NG', 'Edo', 'NG-ED'),
(1997, 'NG', 'Ekiti', 'NG-EK'),
(1998, 'NG', 'Enugu', 'NG-EN'),
(1999, 'NG', 'Gombe', 'NG-GO'),
(2000, 'NG', 'Imo', 'NG-IM'),
(2001, 'NG', 'Jigawa', 'NG-JI'),
(2002, 'NG', 'Kaduna', 'NG-KD'),
(2003, 'NG', 'Kano', 'NG-KN'),
(2004, 'NG', 'Katsina', 'NG-KT'),
(2005, 'NG', 'Kebbi', 'NG-KE'),
(2006, 'NG', 'Kogi', 'NG-KO'),
(2007, 'NG', 'Kwara', 'NG-KW'),
(2008, 'NG', 'Lagos', 'NG-LA'),
(2009, 'NG', 'Nasarawa', 'NG-NA'),
(2010, 'NG', 'Niger', 'NG-NI'),
(2011, 'NG', 'Ogun', 'NG-OG'),
(2012, 'NG', 'Ondo', 'NG-ON'),
(2013, 'NG', 'Osun', 'NG-OS'),
(2014, 'NG', 'Oyo', 'NG-OY'),
(2015, 'NG', 'Plateau', 'NG-PL'),
(2016, 'NG', 'Rivers', 'NG-RI'),
(2017, 'NG', 'Sokoto', 'NG-SO'),
(2018, 'NG', 'Taraba', 'NG-TA'),
(2019, 'NG', 'Yobe', 'NG-YO'),
(2020, 'NG', 'Zamfara', 'NG-ZA'),
(2021, 'NI', 'Boaco', 'NI-BO'),
(2022, 'NI', 'Carazo', 'NI-CA'),
(2023, 'NI', 'Chinandega', 'NI-CI'),
(2024, 'NI', 'Chontales', 'NI-CO'),
(2025, 'NI', 'Costa Caribe Norte', 'NI-AN'),
(2026, 'NI', 'Costa Caribe Sur', 'NI-AS'),
(2027, 'NI', 'Esteli', 'NI-ES'),
(2028, 'NI', 'Granada', 'NI-GR'),
(2029, 'NI', 'Jinotega', 'NI-JI'),
(2030, 'NI', 'Leon', 'NI-LE'),
(2031, 'NI', 'Madriz', 'NI-MD'),
(2032, 'NI', 'Managua', 'NI-MN'),
(2033, 'NI', 'Masaya', 'NI-MS'),
(2034, 'NI', 'Matagalpa', 'NI-MT'),
(2035, 'NI', 'Nueva Segovia', 'NI-NS'),
(2036, 'NI', 'Rio San Juan', 'NI-SJ'),
(2037, 'NI', 'Rivas', 'NI-RI'),
(2038, 'NL', 'Drenthe', 'NL-DR'),
(2039, 'NL', 'Flevoland', 'NL-FL'),
(2040, 'NL', 'Fryslan', 'NL-FR'),
(2041, 'NL', 'Gelderland', 'NL-GE'),
(2042, 'NL', 'Groningen', 'NL-GR'),
(2043, 'NL', 'Limburg', 'NL-LI'),
(2044, 'NL', 'Noord-Brabant', 'NL-NB'),
(2045, 'NL', 'Noord-Holland', 'NL-NH'),
(2046, 'NL', 'Overijssel', 'NL-OV'),
(2047, 'NL', 'Utrecht', 'NL-UT'),
(2048, 'NL', 'Zeeland', 'NL-ZE'),
(2049, 'NL', 'Zuid-Holland', 'NL-ZH'),
(2050, 'NO', 'Agder', 'NO-42'),
(2051, 'NO', 'Innlandet', 'NO-34'),
(2052, 'NO', 'More og Romsdal', 'NO-15'),
(2053, 'NO', 'Nordland', 'NO-18'),
(2054, 'NO', 'Oslo', 'NO-03'),
(2055, 'NO', 'Rogaland', 'NO-11'),
(2056, 'NO', 'Troms og Finnmark', 'NO-54'),
(2057, 'NO', 'Trondelag', 'NO-50'),
(2058, 'NO', 'Vestfold og Telemark', 'NO-38'),
(2059, 'NO', 'Vestland', 'NO-46'),
(2060, 'NO', 'Viken', 'NO-30'),
(2061, 'NP', 'Bagmati', 'NP-BA'),
(2062, 'NP', 'Bheri', 'NP-BH'),
(2063, 'NP', 'Dhawalagiri', 'NP-DH'),
(2064, 'NP', 'Gandaki', 'NP-GA'),
(2065, 'NP', 'Janakpur', 'NP-JA'),
(2066, 'NP', 'Karnali', 'NP-KA'),
(2067, 'NP', 'Kosi', 'NP-KO'),
(2068, 'NP', 'Lumbini', 'NP-LU'),
(2069, 'NP', 'Mahakali', 'NP-MA'),
(2070, 'NP', 'Mechi', 'NP-ME'),
(2071, 'NP', 'Narayani', 'NP-NA'),
(2072, 'NP', 'Rapti', 'NP-RA'),
(2073, 'NP', 'Sagarmatha', 'NP-SA'),
(2074, 'NP', 'Seti', 'NP-SE'),
(2075, 'NR', 'Yaren', 'NR-14'),
(2076, 'NU', 'Niue', '-'),
(2077, 'NZ', 'Auckland', 'NZ-AUK'),
(2078, 'NZ', 'Bay of Plenty', 'NZ-BOP'),
(2079, 'NZ', 'Canterbury', 'NZ-CAN'),
(2080, 'NZ', 'Chatham Islands Territory', 'NZ-CIT'),
(2081, 'NZ', 'Gisborne', 'NZ-GIS'),
(2082, 'NZ', 'Hawkes Bay', 'NZ-HKB'),
(2083, 'NZ', 'Manawatu-Wanganui', 'NZ-MWT'),
(2084, 'NZ', 'Marlborough', 'NZ-MBH'),
(2085, 'NZ', 'Nelson', 'NZ-NSN'),
(2086, 'NZ', 'Northland', 'NZ-NTL'),
(2087, 'NZ', 'Otago', 'NZ-OTA'),
(2088, 'NZ', 'Southland', 'NZ-STL'),
(2089, 'NZ', 'Taranaki', 'NZ-TKI'),
(2090, 'NZ', 'Tasman', 'NZ-TAS'),
(2091, 'NZ', 'Waikato', 'NZ-WKO'),
(2092, 'NZ', 'Wellington', 'NZ-WGN'),
(2093, 'NZ', 'West Coast', 'NZ-WTC'),
(2094, 'OM', 'Ad Dakhiliyah', 'OM-DA'),
(2095, 'OM', 'Al Buraymi', 'OM-BU'),
(2096, 'OM', 'Al Wusta', 'OM-WU'),
(2097, 'OM', 'Az Zahirah', 'OM-ZA'),
(2098, 'OM', 'Janub al Batinah', 'OM-BJ'),
(2099, 'OM', 'Janub ash Sharqiyah', 'OM-SJ'),
(2100, 'OM', 'Masqat', 'OM-MA'),
(2101, 'OM', 'Musandam', 'OM-MU'),
(2102, 'OM', 'Shamal al Batinah', 'OM-BS'),
(2103, 'OM', 'Shamal ash Sharqiyah', 'OM-SS'),
(2104, 'OM', 'Zufar', 'OM-ZU'),
(2105, 'PA', 'Bocas del Toro', 'PA-1'),
(2106, 'PA', 'Chiriqui', 'PA-4'),
(2107, 'PA', 'Cocle', 'PA-2'),
(2108, 'PA', 'Colon', 'PA-3'),
(2109, 'PA', 'Darien', 'PA-5'),
(2110, 'PA', 'Herrera', 'PA-6'),
(2111, 'PA', 'Los Santos', 'PA-7'),
(2112, 'PA', 'Ngobe-Bugle', 'PA-NB'),
(2113, 'PA', 'Panama', 'PA-8'),
(2114, 'PA', 'Veraguas', 'PA-9'),
(2115, 'PE', 'Amazonas', 'PE-AMA'),
(2116, 'PE', 'Ancash', 'PE-ANC'),
(2117, 'PE', 'Apurimac', 'PE-APU'),
(2118, 'PE', 'Arequipa', 'PE-ARE'),
(2119, 'PE', 'Ayacucho', 'PE-AYA'),
(2120, 'PE', 'Cajamarca', 'PE-CAJ'),
(2121, 'PE', 'Cusco', 'PE-CUS'),
(2122, 'PE', 'El Callao', 'PE-CAL'),
(2123, 'PE', 'Huancavelica', 'PE-HUV'),
(2124, 'PE', 'Huanuco', 'PE-HUC'),
(2125, 'PE', 'Ica', 'PE-ICA'),
(2126, 'PE', 'Junin', 'PE-JUN'),
(2127, 'PE', 'La Libertad', 'PE-LAL'),
(2128, 'PE', 'Lambayeque', 'PE-LAM'),
(2129, 'PE', 'Lima', 'PE-LIM'),
(2130, 'PE', 'Loreto', 'PE-LOR'),
(2131, 'PE', 'Madre de Dios', 'PE-MDD'),
(2132, 'PE', 'Moquegua', 'PE-MOQ'),
(2133, 'PE', 'Pasco', 'PE-PAS'),
(2134, 'PE', 'Piura', 'PE-PIU'),
(2135, 'PE', 'Puno', 'PE-PUN'),
(2136, 'PE', 'San Martin', 'PE-SAM'),
(2137, 'PE', 'Tacna', 'PE-TAC'),
(2138, 'PE', 'Tumbes', 'PE-TUM'),
(2139, 'PE', 'Ucayali', 'PE-UCA'),
(2140, 'PF', 'Iles Australes', '-'),
(2141, 'PF', 'Iles Marquises', '-'),
(2142, 'PF', 'Iles Sous-le-Vent', '-'),
(2143, 'PF', 'Iles Tuamotu-Gambier', '-'),
(2144, 'PF', 'Iles du Vent', '-'),
(2145, 'PG', 'Bougainville', 'PG-NSB'),
(2146, 'PG', 'Central', 'PG-CPM'),
(2147, 'PG', 'East New Britain', 'PG-EBR'),
(2148, 'PG', 'East Sepik', 'PG-ESW'),
(2149, 'PG', 'Eastern Highlands', 'PG-EHG'),
(2150, 'PG', 'Madang', 'PG-MPM'),
(2151, 'PG', 'Manus', 'PG-MRL'),
(2152, 'PG', 'Milne Bay', 'PG-MBA'),
(2153, 'PG', 'Morobe', 'PG-MPL'),
(2154, 'PG', 'National Capital District (Port Moresby)', 'PG-NCD'),
(2155, 'PG', 'New Ireland', 'PG-NIK'),
(2156, 'PG', 'Southern Highlands', 'PG-SHM'),
(2157, 'PG', 'West New Britain', 'PG-WBK'),
(2158, 'PG', 'West Sepik', 'PG-SAN'),
(2159, 'PG', 'Western', 'PG-WPD'),
(2160, 'PG', 'Western Highlands', 'PG-WHM'),
(2161, 'PH', 'Abra', 'PH-ABR'),
(2162, 'PH', 'Agusan del Norte', 'PH-AGN'),
(2163, 'PH', 'Agusan del Sur', 'PH-AGS'),
(2164, 'PH', 'Aklan', 'PH-AKL'),
(2165, 'PH', 'Albay', 'PH-ALB'),
(2166, 'PH', 'Antique', 'PH-ANT'),
(2167, 'PH', 'Apayao', 'PH-APA'),
(2168, 'PH', 'Aurora', 'PH-AUR'),
(2169, 'PH', 'Basilan', 'PH-BAS'),
(2170, 'PH', 'Bataan', 'PH-BAN'),
(2171, 'PH', 'Batanes', 'PH-BTN'),
(2172, 'PH', 'Batangas', 'PH-BTG'),
(2173, 'PH', 'Benguet', 'PH-BEN'),
(2174, 'PH', 'Biliran', 'PH-BIL'),
(2175, 'PH', 'Bohol', 'PH-BOH'),
(2176, 'PH', 'Bukidnon', 'PH-BUK'),
(2177, 'PH', 'Bulacan', 'PH-BUL'),
(2178, 'PH', 'Cagayan', 'PH-CAG'),
(2179, 'PH', 'Camarines Norte', 'PH-CAN'),
(2180, 'PH', 'Camarines Sur', 'PH-CAS'),
(2181, 'PH', 'Camiguin', 'PH-CAM'),
(2182, 'PH', 'Capiz', 'PH-CAP'),
(2183, 'PH', 'Catanduanes', 'PH-CAT'),
(2184, 'PH', 'Cavite', 'PH-CAV'),
(2185, 'PH', 'Cebu', 'PH-CEB'),
(2186, 'PH', 'Cotabato', 'PH-NCO'),
(2187, 'PH', 'Davao Oriental', 'PH-DAO'),
(2188, 'PH', 'Davao de Oro', 'PH-COM'),
(2189, 'PH', 'Davao del Norte', 'PH-DAV'),
(2190, 'PH', 'Davao del Sur', 'PH-DAS'),
(2191, 'PH', 'Dinagat Islands', 'PH-DIN'),
(2192, 'PH', 'Eastern Samar', 'PH-EAS'),
(2193, 'PH', 'Guimaras', 'PH-GUI'),
(2194, 'PH', 'Ifugao', 'PH-IFU'),
(2195, 'PH', 'Ilocos Norte', 'PH-ILN'),
(2196, 'PH', 'Ilocos Sur', 'PH-ILS'),
(2197, 'PH', 'Iloilo', 'PH-ILI'),
(2198, 'PH', 'Isabela', 'PH-ISA'),
(2199, 'PH', 'Kalinga', 'PH-KAL'),
(2200, 'PH', 'La Union', 'PH-LUN'),
(2201, 'PH', 'Laguna', 'PH-LAG'),
(2202, 'PH', 'Lanao del Norte', 'PH-LAN'),
(2203, 'PH', 'Lanao del Sur', 'PH-LAS'),
(2204, 'PH', 'Leyte', 'PH-LEY'),
(2205, 'PH', 'Maguindanao', 'PH-MAG'),
(2206, 'PH', 'Marinduque', 'PH-MAD'),
(2207, 'PH', 'Masbate', 'PH-MAS'),
(2208, 'PH', 'Mindoro Occidental', 'PH-MDC'),
(2209, 'PH', 'Mindoro Oriental', 'PH-MDR'),
(2210, 'PH', 'Misamis Occidental', 'PH-MSC'),
(2211, 'PH', 'Misamis Oriental', 'PH-MSR'),
(2212, 'PH', 'Mountain Province', 'PH-MOU'),
(2213, 'PH', 'National Capital Region', 'PH-00'),
(2214, 'PH', 'Negros Occidental', 'PH-NEC'),
(2215, 'PH', 'Negros Oriental', 'PH-NER'),
(2216, 'PH', 'Northern Samar', 'PH-NSA'),
(2217, 'PH', 'Nueva Ecija', 'PH-NUE'),
(2218, 'PH', 'Nueva Vizcaya', 'PH-NUV'),
(2219, 'PH', 'Palawan', 'PH-PLW'),
(2220, 'PH', 'Pampanga', 'PH-PAM'),
(2221, 'PH', 'Pangasinan', 'PH-PAN'),
(2222, 'PH', 'Quezon', 'PH-QUE'),
(2223, 'PH', 'Quirino', 'PH-QUI'),
(2224, 'PH', 'Rizal', 'PH-RIZ'),
(2225, 'PH', 'Romblon', 'PH-ROM'),
(2226, 'PH', 'Samar', 'PH-WSA'),
(2227, 'PH', 'Sarangani', 'PH-SAR'),
(2228, 'PH', 'Siquijor', 'PH-SIG'),
(2229, 'PH', 'Sorsogon', 'PH-SOR'),
(2230, 'PH', 'South Cotabato', 'PH-SCO'),
(2231, 'PH', 'Southern Leyte', 'PH-SLE'),
(2232, 'PH', 'Sultan Kudarat', 'PH-SUK'),
(2233, 'PH', 'Sulu', 'PH-SLU'),
(2234, 'PH', 'Surigao del Norte', 'PH-SUN'),
(2235, 'PH', 'Surigao del Sur', 'PH-SUR'),
(2236, 'PH', 'Tarlac', 'PH-TAR'),
(2237, 'PH', 'Tawi-Tawi', 'PH-TAW'),
(2238, 'PH', 'Zambales', 'PH-ZMB'),
(2239, 'PH', 'Zamboanga Sibugay', 'PH-ZSI'),
(2240, 'PH', 'Zamboanga del Norte', 'PH-ZAN'),
(2241, 'PH', 'Zamboanga del Sur', 'PH-ZAS'),
(2242, 'PK', 'Azad Jammu and Kashmir', 'PK-JK'),
(2243, 'PK', 'Balochistan', 'PK-BA'),
(2244, 'PK', 'Gilgit-Baltistan', 'PK-GB'),
(2245, 'PK', 'Islamabad', 'PK-IS'),
(2246, 'PK', 'Khyber Pakhtunkhwa', 'PK-KP'),
(2247, 'PK', 'Punjab', 'PK-PB'),
(2248, 'PK', 'Sindh', 'PK-SD'),
(2249, 'PL', 'Dolnoslaskie', 'PL-02'),
(2250, 'PL', 'Kujawsko-pomorskie', 'PL-04'),
(2251, 'PL', 'Lodzkie', 'PL-10'),
(2252, 'PL', 'Lubelskie', 'PL-06'),
(2253, 'PL', 'Lubuskie', 'PL-08'),
(2254, 'PL', 'Malopolskie', 'PL-12'),
(2255, 'PL', 'Mazowieckie', 'PL-14'),
(2256, 'PL', 'Opolskie', 'PL-16'),
(2257, 'PL', 'Podkarpackie', 'PL-18'),
(2258, 'PL', 'Podlaskie', 'PL-20'),
(2259, 'PL', 'Pomorskie', 'PL-22'),
(2260, 'PL', 'Slaskie', 'PL-24'),
(2261, 'PL', 'Swietokrzyskie', 'PL-26'),
(2262, 'PL', 'Warminsko-mazurskie', 'PL-28'),
(2263, 'PL', 'Wielkopolskie', 'PL-30'),
(2264, 'PL', 'Zachodniopomorskie', 'PL-32'),
(2265, 'PM', 'Saint Pierre and Miquelon', '-'),
(2266, 'PN', 'Pitcairn', '-'),
(2267, 'PR', 'Adjuntas', '-'),
(2268, 'PR', 'Aguada', '-'),
(2269, 'PR', 'Aguadilla', '-'),
(2270, 'PR', 'Aguas Buenas', '-'),
(2271, 'PR', 'Aibonito', '-'),
(2272, 'PR', 'Anasco', '-'),
(2273, 'PR', 'Arecibo', '-'),
(2274, 'PR', 'Arroyo', '-'),
(2275, 'PR', 'Barceloneta', '-'),
(2276, 'PR', 'Barranquitas', '-'),
(2277, 'PR', 'Bayamon', '-'),
(2278, 'PR', 'Cabo Rojo', '-'),
(2279, 'PR', 'Caguas', '-'),
(2280, 'PR', 'Camuy', '-'),
(2281, 'PR', 'Canovanas', '-'),
(2282, 'PR', 'Carolina', '-'),
(2283, 'PR', 'Catano', '-'),
(2284, 'PR', 'Cayey', '-'),
(2285, 'PR', 'Ceiba', '-'),
(2286, 'PR', 'Ciales', '-'),
(2287, 'PR', 'Cidra', '-'),
(2288, 'PR', 'Coamo', '-'),
(2289, 'PR', 'Comerio', '-'),
(2290, 'PR', 'Corozal', '-'),
(2291, 'PR', 'Culebra', '-'),
(2292, 'PR', 'Dorado', '-'),
(2293, 'PR', 'Fajardo', '-'),
(2294, 'PR', 'Florida', '-'),
(2295, 'PR', 'Guanica', '-'),
(2296, 'PR', 'Guayama', '-'),
(2297, 'PR', 'Guayanilla', '-'),
(2298, 'PR', 'Guaynabo', '-'),
(2299, 'PR', 'Gurabo', '-'),
(2300, 'PR', 'Hatillo', '-'),
(2301, 'PR', 'Hormigueros', '-'),
(2302, 'PR', 'Humacao', '-'),
(2303, 'PR', 'Isabela', '-'),
(2304, 'PR', 'Juana Diaz', '-'),
(2305, 'PR', 'Lajas', '-'),
(2306, 'PR', 'Lares', '-'),
(2307, 'PR', 'Las Marias', '-'),
(2308, 'PR', 'Las Piedras', '-'),
(2309, 'PR', 'Loiza', '-'),
(2310, 'PR', 'Luquillo', '-'),
(2311, 'PR', 'Manati', '-'),
(2312, 'PR', 'Mayaguez', '-'),
(2313, 'PR', 'Moca', '-'),
(2314, 'PR', 'Morovis', '-'),
(2315, 'PR', 'Municipio de Jayuya', '-'),
(2316, 'PR', 'Municipio de Juncos', '-'),
(2317, 'PR', 'Naguabo', '-'),
(2318, 'PR', 'Naranjito', '-'),
(2319, 'PR', 'Patillas', '-'),
(2320, 'PR', 'Penuelas', '-'),
(2321, 'PR', 'Ponce', '-'),
(2322, 'PR', 'Quebradillas', '-'),
(2323, 'PR', 'Rincon', '-'),
(2324, 'PR', 'Rio Grande', '-'),
(2325, 'PR', 'Sabana Grande', '-'),
(2326, 'PR', 'Salinas', '-'),
(2327, 'PR', 'San German', '-'),
(2328, 'PR', 'San Juan', '-'),
(2329, 'PR', 'San Lorenzo', '-'),
(2330, 'PR', 'San Sebastian', '-'),
(2331, 'PR', 'Santa Isabel Municipio', '-'),
(2332, 'PR', 'Toa Alta', '-'),
(2333, 'PR', 'Toa Baja', '-'),
(2334, 'PR', 'Trujillo Alto', '-'),
(2335, 'PR', 'Utuado', '-'),
(2336, 'PR', 'Vega Alta', '-'),
(2337, 'PR', 'Vega Baja', '-'),
(2338, 'PR', 'Vieques', '-'),
(2339, 'PR', 'Villalba', '-'),
(2340, 'PR', 'Yabucoa', '-'),
(2341, 'PR', 'Yauco', '-'),
(2342, 'PS', 'Bethlehem', 'PS-BTH'),
(2343, 'PS', 'Deir El Balah', 'PS-DEB'),
(2344, 'PS', 'Gaza', 'PS-GZA'),
(2345, 'PS', 'Hebron', 'PS-HBN'),
(2346, 'PS', 'Jenin', 'PS-JEN'),
(2347, 'PS', 'Jericho and Al Aghwar', 'PS-JRH'),
(2348, 'PS', 'Jerusalem', 'PS-JEM'),
(2349, 'PS', 'Khan Yunis', 'PS-KYS'),
(2350, 'PS', 'Nablus', 'PS-NBS'),
(2351, 'PS', 'Qalqilya', 'PS-QQA'),
(2352, 'PS', 'Rafah', 'PS-RFH'),
(2353, 'PS', 'Ramallah', 'PS-RBH'),
(2354, 'PS', 'Salfit', 'PS-SLT'),
(2355, 'PS', 'Tubas', 'PS-TBS'),
(2356, 'PS', 'Tulkarm', 'PS-TKM'),
(2357, 'PT', 'Aveiro', 'PT-01'),
(2358, 'PT', 'Beja', 'PT-02'),
(2359, 'PT', 'Braga', 'PT-03'),
(2360, 'PT', 'Braganca', 'PT-04'),
(2361, 'PT', 'Castelo Branco', 'PT-05'),
(2362, 'PT', 'Coimbra', 'PT-06'),
(2363, 'PT', 'Evora', 'PT-07'),
(2364, 'PT', 'Faro', 'PT-08'),
(2365, 'PT', 'Guarda', 'PT-09'),
(2366, 'PT', 'Leiria', 'PT-10'),
(2367, 'PT', 'Lisboa', 'PT-11'),
(2368, 'PT', 'Portalegre', 'PT-12'),
(2369, 'PT', 'Porto', 'PT-13'),
(2370, 'PT', 'Regiao Autonoma da Madeira', 'PT-30'),
(2371, 'PT', 'Regiao Autonoma dos Acores', 'PT-20'),
(2372, 'PT', 'Santarem', 'PT-14'),
(2373, 'PT', 'Setubal', 'PT-15'),
(2374, 'PT', 'Viana do Castelo', 'PT-16'),
(2375, 'PT', 'Vila Real', 'PT-17'),
(2376, 'PT', 'Viseu', 'PT-18'),
(2377, 'PW', 'Airai', 'PW-004'),
(2378, 'PW', 'Kayangel', 'PW-100'),
(2379, 'PW', 'Koror', 'PW-150'),
(2380, 'PW', 'Melekeok', 'PW-212'),
(2381, 'PW', 'Ngaraard', 'PW-214'),
(2382, 'PW', 'Ngardmau', 'PW-222'),
(2383, 'PY', 'Alto Parana', 'PY-10'),
(2384, 'PY', 'Amambay', 'PY-13'),
(2385, 'PY', 'Asuncion', 'PY-ASU'),
(2386, 'PY', 'Boqueron', 'PY-19'),
(2387, 'PY', 'Caaguazu', 'PY-5'),
(2388, 'PY', 'Caazapa', 'PY-6'),
(2389, 'PY', 'Canindeyu', 'PY-14'),
(2390, 'PY', 'Central', 'PY-11'),
(2391, 'PY', 'Concepcion', 'PY-1'),
(2392, 'PY', 'Cordillera', 'PY-3'),
(2393, 'PY', 'Guaira', 'PY-4'),
(2394, 'PY', 'Itapua', 'PY-7'),
(2395, 'PY', 'Misiones', 'PY-8'),
(2396, 'PY', 'Neembucu', 'PY-12'),
(2397, 'PY', 'Paraguari', 'PY-9'),
(2398, 'PY', 'Presidente Hayes', 'PY-15'),
(2399, 'PY', 'San Pedro', 'PY-2'),
(2400, 'QA', 'Ad Dawhah', 'QA-DA'),
(2401, 'QA', 'Al Khawr wa adh Dhakhirah', 'QA-KH'),
(2402, 'QA', 'Al Wakrah', 'QA-WA'),
(2403, 'QA', 'Ar Rayyan', 'QA-RA'),
(2404, 'QA', 'Ash Shamal', 'QA-MS'),
(2405, 'QA', 'Az Zaayin', 'QA-ZA'),
(2406, 'QA', 'Umm Salal', 'QA-US'),
(2407, 'RE', 'Reunion', '-'),
(2408, 'RO', 'Alba', 'RO-AB'),
(2409, 'RO', 'Arad', 'RO-AR'),
(2410, 'RO', 'Arges', 'RO-AG'),
(2411, 'RO', 'Bacau', 'RO-BC'),
(2412, 'RO', 'Bihor', 'RO-BH'),
(2413, 'RO', 'Bistrita-Nasaud', 'RO-BN'),
(2414, 'RO', 'Botosani', 'RO-BT'),
(2415, 'RO', 'Braila', 'RO-BR'),
(2416, 'RO', 'Brasov', 'RO-BV'),
(2417, 'RO', 'Bucuresti', 'RO-B'),
(2418, 'RO', 'Buzau', 'RO-BZ'),
(2419, 'RO', 'Calarasi', 'RO-CL'),
(2420, 'RO', 'Caras-Severin', 'RO-CS'),
(2421, 'RO', 'Cluj', 'RO-CJ'),
(2422, 'RO', 'Constanta', 'RO-CT'),
(2423, 'RO', 'Covasna', 'RO-CV'),
(2424, 'RO', 'Dambovita', 'RO-DB'),
(2425, 'RO', 'Dolj', 'RO-DJ'),
(2426, 'RO', 'Galati', 'RO-GL'),
(2427, 'RO', 'Giurgiu', 'RO-GR'),
(2428, 'RO', 'Gorj', 'RO-GJ'),
(2429, 'RO', 'Harghita', 'RO-HR'),
(2430, 'RO', 'Hunedoara', 'RO-HD'),
(2431, 'RO', 'Ialomita', 'RO-IL'),
(2432, 'RO', 'Iasi', 'RO-IS'),
(2433, 'RO', 'Ilfov', 'RO-IF'),
(2434, 'RO', 'Maramures', 'RO-MM'),
(2435, 'RO', 'Mehedinti', 'RO-MH'),
(2436, 'RO', 'Mures', 'RO-MS'),
(2437, 'RO', 'Neamt', 'RO-NT'),
(2438, 'RO', 'Olt', 'RO-OT'),
(2439, 'RO', 'Prahova', 'RO-PH'),
(2440, 'RO', 'Salaj', 'RO-SJ'),
(2441, 'RO', 'Satu Mare', 'RO-SM'),
(2442, 'RO', 'Sibiu', 'RO-SB'),
(2443, 'RO', 'Suceava', 'RO-SV'),
(2444, 'RO', 'Teleorman', 'RO-TR'),
(2445, 'RO', 'Timis', 'RO-TM'),
(2446, 'RO', 'Tulcea', 'RO-TL'),
(2447, 'RO', 'Valcea', 'RO-VL'),
(2448, 'RO', 'Vaslui', 'RO-VS'),
(2449, 'RO', 'Vrancea', 'RO-VN'),
(2450, 'RS', 'Beograd', 'RS-00'),
(2451, 'RS', 'Borski okrug', 'RS-14'),
(2452, 'RS', 'Branicevski okrug', 'RS-11'),
(2453, 'RS', 'Jablanicki okrug', 'RS-23'),
(2454, 'RS', 'Juznobacki okrug', 'RS-06'),
(2455, 'RS', 'Juznobanatski okrug', 'RS-04'),
(2456, 'RS', 'Kolubarski okrug', 'RS-09'),
(2457, 'RS', 'Kosovsko-Mitrovacki okrug', 'RS-28'),
(2458, 'RS', 'Macvanski okrug', 'RS-08'),
(2459, 'RS', 'Moravicki okrug', 'RS-17'),
(2460, 'RS', 'Nisavski okrug', 'RS-20'),
(2461, 'RS', 'Pcinjski okrug', 'RS-24'),
(2462, 'RS', 'Pecki okrug', 'RS-26'),
(2463, 'RS', 'Pirotski okrug', 'RS-22'),
(2464, 'RS', 'Podunavski okrug', 'RS-10'),
(2465, 'RS', 'Pomoravski okrug', 'RS-13'),
(2466, 'RS', 'Prizrenski okrug', 'RS-27'),
(2467, 'RS', 'Rasinski okrug', 'RS-19'),
(2468, 'RS', 'Raski okrug', 'RS-18'),
(2469, 'RS', 'Severnobacki okrug', 'RS-01'),
(2470, 'RS', 'Severnobanatski okrug', 'RS-03'),
(2471, 'RS', 'Srednjebanatski okrug', 'RS-02'),
(2472, 'RS', 'Sremski okrug', 'RS-07'),
(2473, 'RS', 'Sumadijski okrug', 'RS-12'),
(2474, 'RS', 'Toplicki okrug', 'RS-21'),
(2475, 'RS', 'Zajecarski okrug', 'RS-15'),
(2476, 'RS', 'Zapadnobacki okrug', 'RS-05'),
(2477, 'RS', 'Zlatiborski okrug', 'RS-16'),
(2478, 'RU', 'Adygeya, Respublika', 'RU-AD'),
(2479, 'RU', 'Altay, Respublika', 'RU-AL'),
(2480, 'RU', 'Altayskiy kray', 'RU-ALT'),
(2481, 'RU', 'Amurskaya oblast', 'RU-AMU'),
(2482, 'RU', 'Arkhangelskaya oblast', 'RU-ARK'),
(2483, 'RU', 'Astrakhanskaya oblast', 'RU-AST'),
(2484, 'RU', 'Bashkortostan, Respublika', 'RU-BA'),
(2485, 'RU', 'Belgorodskaya oblast', 'RU-BEL'),
(2486, 'RU', 'Bryanskaya oblast', 'RU-BRY'),
(2487, 'RU', 'Buryatiya, Respublika', 'RU-BU'),
(2488, 'RU', 'Chechenskaya Respublika', 'RU-CE'),
(2489, 'RU', 'Chelyabinskaya oblast', 'RU-CHE'),
(2490, 'RU', 'Chukotskiy avtonomnyy okrug', 'RU-CHU'),
(2491, 'RU', 'Chuvashskaya Respublika', 'RU-CU'),
(2492, 'RU', 'Dagestan, Respublika', 'RU-DA'),
(2493, 'RU', 'Ingushetiya, Respublika', 'RU-IN'),
(2494, 'RU', 'Irkutskaya oblast', 'RU-IRK'),
(2495, 'RU', 'Ivanovskaya oblast', 'RU-IVA'),
(2496, 'RU', 'Kabardino-Balkarskaya Respublika', 'RU-KB'),
(2497, 'RU', 'Kaliningradskaya oblast', 'RU-KGD'),
(2498, 'RU', 'Kalmykiya, Respublika', 'RU-KL'),
(2499, 'RU', 'Kaluzhskaya oblast', 'RU-KLU'),
(2500, 'RU', 'Kamchatskiy kray', 'RU-KAM'),
(2501, 'RU', 'Karachayevo-Cherkesskaya Respublika', 'RU-KC'),
(2502, 'RU', 'Kareliya, Respublika', 'RU-KR'),
(2503, 'RU', 'Kemerovskaya oblast', 'RU-KEM'),
(2504, 'RU', 'Khabarovskiy kray', 'RU-KHA'),
(2505, 'RU', 'Khakasiya, Respublika', 'RU-KK'),
(2506, 'RU', 'Khanty-Mansiyskiy avtonomnyy okrug', 'RU-KHM'),
(2507, 'RU', 'Kirovskaya oblast', 'RU-KIR'),
(2508, 'RU', 'Komi, Respublika', 'RU-KO'),
(2509, 'RU', 'Kostromskaya oblast', 'RU-KOS'),
(2510, 'RU', 'Krasnodarskiy kray', 'RU-KDA'),
(2511, 'RU', 'Krasnoyarskiy kray', 'RU-KYA'),
(2512, 'RU', 'Kurganskaya oblast', 'RU-KGN'),
(2513, 'RU', 'Kurskaya oblast', 'RU-KRS'),
(2514, 'RU', 'Leningradskaya oblast', 'RU-LEN'),
(2515, 'RU', 'Lipetskaya oblast', 'RU-LIP'),
(2516, 'RU', 'Magadanskaya oblast', 'RU-MAG'),
(2517, 'RU', 'Mariy El, Respublika', 'RU-ME'),
(2518, 'RU', 'Mordoviya, Respublika', 'RU-MO'),
(2519, 'RU', 'Moskovskaya oblast', 'RU-MOS'),
(2520, 'RU', 'Moskva', 'RU-MOW'),
(2521, 'RU', 'Murmanskaya oblast', 'RU-MUR'),
(2522, 'RU', 'Nenetskiy avtonomnyy okrug', 'RU-NEN'),
(2523, 'RU', 'Nizhegorodskaya oblast', 'RU-NIZ'),
(2524, 'RU', 'Novgorodskaya oblast', 'RU-NGR'),
(2525, 'RU', 'Novosibirskaya oblast', 'RU-NVS'),
(2526, 'RU', 'Omskaya oblast', 'RU-OMS'),
(2527, 'RU', 'Orenburgskaya oblast', 'RU-ORE'),
(2528, 'RU', 'Orlovskaya oblast', 'RU-ORL'),
(2529, 'RU', 'Penzenskaya oblast', 'RU-PNZ'),
(2530, 'RU', 'Permskiy kray', 'RU-PER'),
(2531, 'RU', 'Primorskiy kray', 'RU-PRI'),
(2532, 'RU', 'Pskovskaya oblast', 'RU-PSK'),
(2533, 'RU', 'Rostovskaya oblast', 'RU-ROS'),
(2534, 'RU', 'Ryazanskaya oblast', 'RU-RYA'),
(2535, 'RU', 'Saha, Respublika', 'RU-SA'),
(2536, 'RU', 'Sakhalinskaya oblast', 'RU-SAK'),
(2537, 'RU', 'Samarskaya oblast', 'RU-SAM'),
(2538, 'RU', 'Sankt-Peterburg', 'RU-SPE'),
(2539, 'RU', 'Saratovskaya oblast', 'RU-SAR'),
(2540, 'RU', 'Severnaya Osetiya, Respublika', 'RU-SE'),
(2541, 'RU', 'Smolenskaya oblast', 'RU-SMO'),
(2542, 'RU', 'Stavropolskiy kray', 'RU-STA'),
(2543, 'RU', 'Sverdlovskaya oblast', 'RU-SVE'),
(2544, 'RU', 'Tambovskaya oblast', 'RU-TAM'),
(2545, 'RU', 'Tatarstan, Respublika', 'RU-TA'),
(2546, 'RU', 'Tomskaya oblast', 'RU-TOM'),
(2547, 'RU', 'Tulskaya oblast', 'RU-TUL'),
(2548, 'RU', 'Tverskaya oblast', 'RU-TVE'),
(2549, 'RU', 'Tyumenskaya oblast', 'RU-TYU'),
(2550, 'RU', 'Tyva, Respublika', 'RU-TY'),
(2551, 'RU', 'Udmurtskaya Respublika', 'RU-UD'),
(2552, 'RU', 'Ulyanovskaya oblast', 'RU-ULY'),
(2553, 'RU', 'Vladimirskaya oblast', 'RU-VLA'),
(2554, 'RU', 'Volgogradskaya oblast', 'RU-VGG'),
(2555, 'RU', 'Vologodskaya oblast', 'RU-VLG'),
(2556, 'RU', 'Voronezhskaya oblast', 'RU-VOR'),
(2557, 'RU', 'Yamalo-Nenetskiy avtonomnyy okrug', 'RU-YAN'),
(2558, 'RU', 'Yaroslavskaya oblast', 'RU-YAR'),
(2559, 'RU', 'Yevreyskaya avtonomnaya oblast', 'RU-YEV'),
(2560, 'RU', 'Zabaykalskiy kray', 'RU-ZAB'),
(2561, 'RW', 'Est', 'RW-02'),
(2562, 'RW', 'Nord', 'RW-03'),
(2563, 'RW', 'Ouest', 'RW-04'),
(2564, 'RW', 'Sud', 'RW-05'),
(2565, 'RW', 'Ville de Kigali', 'RW-01'),
(2566, 'SA', 'Asir', 'SA-14'),
(2567, 'SA', 'Al Bahah', 'SA-11'),
(2568, 'SA', 'Al Hudud ash Shamaliyah', 'SA-08'),
(2569, 'SA', 'Al Jawf', 'SA-12'),
(2570, 'SA', 'Al Madinah al Munawwarah', 'SA-03'),
(2571, 'SA', 'Al Qasim', 'SA-05'),
(2572, 'SA', 'Ar Riyad', 'SA-01'),
(2573, 'SA', 'Ash Sharqiyah', 'SA-04'),
(2574, 'SA', 'Hail', 'SA-06'),
(2575, 'SA', 'Jazan', 'SA-09'),
(2576, 'SA', 'Makkah al Mukarramah', 'SA-02'),
(2577, 'SA', 'Najran', 'SA-10'),
(2578, 'SA', 'Tabuk', 'SA-07'),
(2579, 'SB', 'Choiseul', 'SB-CH'),
(2580, 'SB', 'Guadalcanal', 'SB-GU'),
(2581, 'SB', 'Western', 'SB-WE'),
(2582, 'SC', 'Anse Boileau', 'SC-02'),
(2583, 'SC', 'Anse aux Pins', 'SC-01'),
(2584, 'SC', 'Baie Lazare', 'SC-06'),
(2585, 'SC', 'Baie Sainte Anne', 'SC-07'),
(2586, 'SC', 'Beau Vallon', 'SC-08'),
(2587, 'SC', 'Bel Ombre', 'SC-10'),
(2588, 'SC', 'Cascade', 'SC-11'),
(2589, 'SC', 'English River', 'SC-16'),
(2590, 'SC', 'Grand Anse Mahe', 'SC-13'),
(2591, 'SC', 'Grand Anse Praslin', 'SC-14'),
(2592, 'SC', 'La Digue', 'SC-15'),
(2593, 'SC', 'Pointe Larue', 'SC-20'),
(2594, 'SC', 'Takamaka', 'SC-23'),
(2595, 'SD', 'Blue Nile', 'SD-NB'),
(2596, 'SD', 'Central Darfur', 'SD-DC'),
(2597, 'SD', 'Gedaref', 'SD-GD'),
(2598, 'SD', 'Gezira', 'SD-GZ'),
(2599, 'SD', 'Kassala', 'SD-KA'),
(2600, 'SD', 'Khartoum', 'SD-KH'),
(2601, 'SD', 'North Darfur', 'SD-DN'),
(2602, 'SD', 'North Kordofan', 'SD-KN'),
(2603, 'SD', 'Northern', 'SD-NO'),
(2604, 'SD', 'Red Sea', 'SD-RS'),
(2605, 'SD', 'River Nile', 'SD-NR'),
(2606, 'SD', 'Sennar', 'SD-SI'),
(2607, 'SD', 'South Darfur', 'SD-DS'),
(2608, 'SD', 'South Kordofan', 'SD-KS'),
(2609, 'SD', 'West Darfur', 'SD-DW'),
(2610, 'SD', 'West Kordofan', 'SD-GK'),
(2611, 'SD', 'White Nile', 'SD-NW'),
(2612, 'SE', 'Blekinge lan', 'SE-K'),
(2613, 'SE', 'Dalarnas lan', 'SE-W'),
(2614, 'SE', 'Gavleborgs lan', 'SE-X'),
(2615, 'SE', 'Gotlands lan', 'SE-I'),
(2616, 'SE', 'Hallands lan', 'SE-N'),
(2617, 'SE', 'Jamtlands lan', 'SE-Z'),
(2618, 'SE', 'Jonkopings lan', 'SE-F'),
(2619, 'SE', 'Kalmar lan', 'SE-H'),
(2620, 'SE', 'Kronobergs lan', 'SE-G'),
(2621, 'SE', 'Norrbottens lan', 'SE-BD'),
(2622, 'SE', 'Orebro lan', 'SE-T'),
(2623, 'SE', 'Ostergotlands lan', 'SE-E'),
(2624, 'SE', 'Skane lan', 'SE-M'),
(2625, 'SE', 'Sodermanlands lan', 'SE-D'),
(2626, 'SE', 'Stockholms lan', 'SE-AB'),
(2627, 'SE', 'Uppsala lan', 'SE-C'),
(2628, 'SE', 'Varmlands lan', 'SE-S'),
(2629, 'SE', 'Vasterbottens lan', 'SE-AC'),
(2630, 'SE', 'Vasternorrlands lan', 'SE-Y'),
(2631, 'SE', 'Vastmanlands lan', 'SE-U'),
(2632, 'SE', 'Vastra Gotalands lan', 'SE-O'),
(2633, 'SG', 'Singapore', '-'),
(2634, 'SH', 'Saint Helena', 'SH-HL'),
(2635, 'SI', 'Ajdovscina', 'SI-001'),
(2636, 'SI', 'Ankaran', 'SI-213'),
(2637, 'SI', 'Apace', 'SI-195'),
(2638, 'SI', 'Beltinci', 'SI-002'),
(2639, 'SI', 'Benedikt', 'SI-148'),
(2640, 'SI', 'Bistrica ob Sotli', 'SI-149'),
(2641, 'SI', 'Bled', 'SI-003'),
(2642, 'SI', 'Bloke', 'SI-150'),
(2643, 'SI', 'Bohinj', 'SI-004'),
(2644, 'SI', 'Borovnica', 'SI-005'),
(2645, 'SI', 'Bovec', 'SI-006'),
(2646, 'SI', 'Braslovce', 'SI-151'),
(2647, 'SI', 'Brda', 'SI-007'),
(2648, 'SI', 'Brezice', 'SI-009'),
(2649, 'SI', 'Brezovica', 'SI-008'),
(2650, 'SI', 'Cankova', 'SI-152'),
(2651, 'SI', 'Celje', 'SI-011'),
(2652, 'SI', 'Cerklje na Gorenjskem', 'SI-012'),
(2653, 'SI', 'Cerknica', 'SI-013'),
(2654, 'SI', 'Cerkno', 'SI-014'),
(2655, 'SI', 'Cirkulane', 'SI-196'),
(2656, 'SI', 'Crensovci', 'SI-015'),
(2657, 'SI', 'Crnomelj', 'SI-017'),
(2658, 'SI', 'Destrnik', 'SI-018'),
(2659, 'SI', 'Divaca', 'SI-019'),
(2660, 'SI', 'Dobje', 'SI-154'),
(2661, 'SI', 'Dobrepolje', 'SI-020'),
(2662, 'SI', 'Dobrna', 'SI-155'),
(2663, 'SI', 'Dobrova-Polhov Gradec', 'SI-021'),
(2664, 'SI', 'Dobrovnik', 'SI-156'),
(2665, 'SI', 'Domzale', 'SI-023'),
(2666, 'SI', 'Dornava', 'SI-024'),
(2667, 'SI', 'Dravograd', 'SI-025'),
(2668, 'SI', 'Duplek', 'SI-026'),
(2669, 'SI', 'Gorje', 'SI-207'),
(2670, 'SI', 'Gornja Radgona', 'SI-029'),
(2671, 'SI', 'Gornji Petrovci', 'SI-031'),
(2672, 'SI', 'Grad', 'SI-158'),
(2673, 'SI', 'Grosuplje', 'SI-032'),
(2674, 'SI', 'Hajdina', 'SI-159'),
(2675, 'SI', 'Hoce-Slivnica', 'SI-160'),
(2676, 'SI', 'Hodos', 'SI-161'),
(2677, 'SI', 'Horjul', 'SI-162'),
(2678, 'SI', 'Hrastnik', 'SI-034'),
(2679, 'SI', 'Hrpelje-Kozina', 'SI-035'),
(2680, 'SI', 'Idrija', 'SI-036'),
(2681, 'SI', 'Ig', 'SI-037'),
(2682, 'SI', 'Ilirska Bistrica', 'SI-038'),
(2683, 'SI', 'Ivancna Gorica', 'SI-039'),
(2684, 'SI', 'Izola', 'SI-040'),
(2685, 'SI', 'Jesenice', 'SI-041'),
(2686, 'SI', 'Jursinci', 'SI-042'),
(2687, 'SI', 'Kamnik', 'SI-043'),
(2688, 'SI', 'Kanal', 'SI-044'),
(2689, 'SI', 'Kidricevo', 'SI-045'),
(2690, 'SI', 'Kobarid', 'SI-046'),
(2691, 'SI', 'Kobilje', 'SI-047'),
(2692, 'SI', 'Kocevje', 'SI-048'),
(2693, 'SI', 'Komen', 'SI-049'),
(2694, 'SI', 'Komenda', 'SI-164'),
(2695, 'SI', 'Koper', 'SI-050'),
(2696, 'SI', 'Kosanjevica na Krki', 'SI-197'),
(2697, 'SI', 'Kostel', 'SI-165'),
(2698, 'SI', 'Kranj', 'SI-052'),
(2699, 'SI', 'Kranjska Gora', 'SI-053'),
(2700, 'SI', 'Krizevci', 'SI-166'),
(2701, 'SI', 'Krsko', 'SI-054'),
(2702, 'SI', 'Kungota', 'SI-055'),
(2703, 'SI', 'Kuzma', 'SI-056'),
(2704, 'SI', 'Lasko', 'SI-057'),
(2705, 'SI', 'Lenart', 'SI-058'),
(2706, 'SI', 'Lendava', 'SI-059'),
(2707, 'SI', 'Litija', 'SI-060'),
(2708, 'SI', 'Ljubljana', 'SI-061'),
(2709, 'SI', 'Ljutomer', 'SI-063'),
(2710, 'SI', 'Log-Dragomer', 'SI-208'),
(2711, 'SI', 'Logatec', 'SI-064'),
(2712, 'SI', 'Loska dolina', 'SI-065'),
(2713, 'SI', 'Loski Potok', 'SI-066'),
(2714, 'SI', 'Lovrenc na Pohorju', 'SI-167'),
(2715, 'SI', 'Luce', 'SI-067'),
(2716, 'SI', 'Lukovica', 'SI-068'),
(2717, 'SI', 'Majsperk', 'SI-069'),
(2718, 'SI', 'Makole', 'SI-198'),
(2719, 'SI', 'Maribor', 'SI-070'),
(2720, 'SI', 'Markovci', 'SI-168'),
(2721, 'SI', 'Medvode', 'SI-071'),
(2722, 'SI', 'Menges', 'SI-072'),
(2723, 'SI', 'Metlika', 'SI-073'),
(2724, 'SI', 'Mezica', 'SI-074'),
(2725, 'SI', 'Miklavz na Dravskem polju', 'SI-169'),
(2726, 'SI', 'Miren-Kostanjevica', 'SI-075'),
(2727, 'SI', 'Mirna', 'SI-212'),
(2728, 'SI', 'Mirna Pec', 'SI-170'),
(2729, 'SI', 'Mislinja', 'SI-076'),
(2730, 'SI', 'Mokronog-Trebelno', 'SI-199'),
(2731, 'SI', 'Moravce', 'SI-077'),
(2732, 'SI', 'Mozirje', 'SI-079'),
(2733, 'SI', 'Murska Sobota', 'SI-080'),
(2734, 'SI', 'Muta', 'SI-081'),
(2735, 'SI', 'Naklo', 'SI-082'),
(2736, 'SI', 'Nazarje', 'SI-083'),
(2737, 'SI', 'Nova Gorica', 'SI-084'),
(2738, 'SI', 'Novo Mesto', 'SI-085'),
(2739, 'SI', 'Odranci', 'SI-086'),
(2740, 'SI', 'Oplotnica', 'SI-171'),
(2741, 'SI', 'Ormoz', 'SI-087'),
(2742, 'SI', 'Piran', 'SI-090'),
(2743, 'SI', 'Pivka', 'SI-091'),
(2744, 'SI', 'Podcetrtek', 'SI-092'),
(2745, 'SI', 'Podlehnik', 'SI-172'),
(2746, 'SI', 'Poljcane', 'SI-200'),
(2747, 'SI', 'Polzela', 'SI-173'),
(2748, 'SI', 'Postojna', 'SI-094'),
(2749, 'SI', 'Prebold', 'SI-174'),
(2750, 'SI', 'Preddvor', 'SI-095'),
(2751, 'SI', 'Prevalje', 'SI-175'),
(2752, 'SI', 'Ptuj', 'SI-096'),
(2753, 'SI', 'Puconci', 'SI-097'),
(2754, 'SI', 'Race-Fram', 'SI-098'),
(2755, 'SI', 'Radece', 'SI-099'),
(2756, 'SI', 'Radenci', 'SI-100'),
(2757, 'SI', 'Radlje ob Dravi', 'SI-101'),
(2758, 'SI', 'Radovljica', 'SI-102'),
(2759, 'SI', 'Ravne na Koroskem', 'SI-103'),
(2760, 'SI', 'Razkrizje', 'SI-176'),
(2761, 'SI', 'Recica ob Savinji', 'SI-209'),
(2762, 'SI', 'Rence-Vogrsko', 'SI-201'),
(2763, 'SI', 'Ribnica', 'SI-104'),
(2764, 'SI', 'Rogaska Slatina', 'SI-106'),
(2765, 'SI', 'Rogasovci', 'SI-105'),
(2766, 'SI', 'Ruse', 'SI-108'),
(2767, 'SI', 'Salovci', 'SI-033'),
(2768, 'SI', 'Semic', 'SI-109'),
(2769, 'SI', 'Sempeter-Vrtojba', 'SI-183'),
(2770, 'SI', 'Sencur', 'SI-117'),
(2771, 'SI', 'Sentilj', 'SI-118'),
(2772, 'SI', 'Sentjernej', 'SI-119'),
(2773, 'SI', 'Sentjur', 'SI-120'),
(2774, 'SI', 'Sentrupert', 'SI-211'),
(2775, 'SI', 'Sevnica', 'SI-110'),
(2776, 'SI', 'Sezana', 'SI-111'),
(2777, 'SI', 'Skocjan', 'SI-121'),
(2778, 'SI', 'Skofja Loka', 'SI-122'),
(2779, 'SI', 'Skofljica', 'SI-123'),
(2780, 'SI', 'Slovenj Gradec', 'SI-112'),
(2781, 'SI', 'Slovenska Bistrica', 'SI-113'),
(2782, 'SI', 'Slovenske Konjice', 'SI-114'),
(2783, 'SI', 'Smarje pri Jelsah', 'SI-124'),
(2784, 'SI', 'Smarjeske Toplice', 'SI-206'),
(2785, 'SI', 'Smartno ob Paki', 'SI-125'),
(2786, 'SI', 'Smartno pri Litiji', 'SI-194'),
(2787, 'SI', 'Sodrazica', 'SI-179'),
(2788, 'SI', 'Solcava', 'SI-180'),
(2789, 'SI', 'Sostanj', 'SI-126'),
(2790, 'SI', 'Starse', 'SI-115'),
(2791, 'SI', 'Store', 'SI-127'),
(2792, 'SI', 'Straza', 'SI-203'),
(2793, 'SI', 'Sveta Trojica v Slovenskih goricah', 'SI-204'),
(2794, 'SI', 'Sveti Andraz v Slovenskih Goricah', 'SI-182'),
(2795, 'SI', 'Sveti Jurij ob Scavnici', 'SI-116'),
(2796, 'SI', 'Sveti Jurij v Slovenskih goricah', 'SI-210'),
(2797, 'SI', 'Sveti Tomaz', 'SI-205'),
(2798, 'SI', 'Tabor', 'SI-184'),
(2799, 'SI', 'Tisina', 'SI-010'),
(2800, 'SI', 'Tolmin', 'SI-128'),
(2801, 'SI', 'Trbovlje', 'SI-129'),
(2802, 'SI', 'Trebnje', 'SI-130'),
(2803, 'SI', 'Trnovska Vas', 'SI-185'),
(2804, 'SI', 'Trzic', 'SI-131'),
(2805, 'SI', 'Trzin', 'SI-186'),
(2806, 'SI', 'Turnisce', 'SI-132'),
(2807, 'SI', 'Velenje', 'SI-133'),
(2808, 'SI', 'Velika Polana', 'SI-187'),
(2809, 'SI', 'Velike Lasce', 'SI-134'),
(2810, 'SI', 'Verzej', 'SI-188'),
(2811, 'SI', 'Videm', 'SI-135'),
(2812, 'SI', 'Vipava', 'SI-136'),
(2813, 'SI', 'Vitanje', 'SI-137'),
(2814, 'SI', 'Vodice', 'SI-138'),
(2815, 'SI', 'Vojnik', 'SI-139'),
(2816, 'SI', 'Vransko', 'SI-189'),
(2817, 'SI', 'Vrhnika', 'SI-140'),
(2818, 'SI', 'Vuzenica', 'SI-141'),
(2819, 'SI', 'Zagorje ob Savi', 'SI-142'),
(2820, 'SI', 'Zalec', 'SI-190'),
(2821, 'SI', 'Zavrc', 'SI-143'),
(2822, 'SI', 'Zelezniki', 'SI-146'),
(2823, 'SI', 'Zetale', 'SI-191'),
(2824, 'SI', 'Ziri', 'SI-147'),
(2825, 'SI', 'Zrece', 'SI-144'),
(2826, 'SI', 'Zuzemberk', 'SI-193'),
(2827, 'SK', 'Banskobystricky kraj', 'SK-BC'),
(2828, 'SK', 'Bratislavsky kraj', 'SK-BL'),
(2829, 'SK', 'Kosicky kraj', 'SK-KI'),
(2830, 'SK', 'Nitriansky kraj', 'SK-NI'),
(2831, 'SK', 'Presovsky kraj', 'SK-PV'),
(2832, 'SK', 'Trenciansky kraj', 'SK-TC'),
(2833, 'SK', 'Trnavsky kraj', 'SK-TA'),
(2834, 'SK', 'Zilinsky kraj', 'SK-ZI'),
(2835, 'SL', 'Eastern', 'SL-E'),
(2836, 'SL', 'Northern', 'SL-N'),
(2837, 'SL', 'Southern', 'SL-S'),
(2838, 'SL', 'Western Area', 'SL-W'),
(2839, 'SM', 'Citta di San Marino', 'SM-07'),
(2840, 'SM', 'Domagnano', 'SM-03'),
(2841, 'SM', 'Serravalle', 'SM-09'),
(2842, 'SN', 'Dakar', 'SN-DK'),
(2843, 'SN', 'Diourbel', 'SN-DB'),
(2844, 'SN', 'Fatick', 'SN-FK'),
(2845, 'SN', 'Kaffrine', 'SN-KA'),
(2846, 'SN', 'Kaolack', 'SN-KL'),
(2847, 'SN', 'Kolda', 'SN-KD'),
(2848, 'SN', 'Louga', 'SN-LG'),
(2849, 'SN', 'Matam', 'SN-MT'),
(2850, 'SN', 'Saint-Louis', 'SN-SL'),
(2851, 'SN', 'Tambacounda', 'SN-TC'),
(2852, 'SN', 'Thies', 'SN-TH'),
(2853, 'SN', 'Ziguinchor', 'SN-ZG'),
(2854, 'SO', 'Awdal', 'SO-AW'),
(2855, 'SO', 'Banaadir', 'SO-BN'),
(2856, 'SO', 'Hiiraan', 'SO-HI'),
(2857, 'SO', 'Mudug', 'SO-MU'),
(2858, 'SO', 'Nugaal', 'SO-NU'),
(2859, 'SO', 'Shabeellaha Hoose', 'SO-SH'),
(2860, 'SO', 'Sool', 'SO-SO'),
(2861, 'SO', 'Togdheer', 'SO-TO'),
(2862, 'SO', 'Woqooyi Galbeed', 'SO-WO'),
(2863, 'SR', 'Commewijne', 'SR-CM'),
(2864, 'SR', 'Nickerie', 'SR-NI'),
(2865, 'SR', 'Para', 'SR-PR'),
(2866, 'SR', 'Paramaribo', 'SR-PM'),
(2867, 'SR', 'Sipaliwini', 'SR-SI'),
(2868, 'SR', 'Wanica', 'SR-WA'),
(2869, 'SS', 'Central Equatoria', 'SS-EC'),
(2870, 'SS', 'Eastern Equatoria', 'SS-EE'),
(2871, 'SS', 'Northern Bahr el Ghazal', 'SS-BN'),
(2872, 'SS', 'Upper Nile', 'SS-NU'),
(2873, 'SS', 'Western Equatoria', 'SS-EW'),
(2874, 'ST', 'Agua Grande', 'ST-01'),
(2875, 'SV', 'Ahuachapan', 'SV-AH');
INSERT INTO `rv_region` (`id`, `country_code`, `subdivision_name`, `code`) VALUES
(2876, 'SV', 'Cabanas', 'SV-CA'),
(2877, 'SV', 'Chalatenango', 'SV-CH'),
(2878, 'SV', 'Cuscatlan', 'SV-CU'),
(2879, 'SV', 'La Libertad', 'SV-LI'),
(2880, 'SV', 'La Paz', 'SV-PA'),
(2881, 'SV', 'La Union', 'SV-UN'),
(2882, 'SV', 'Morazan', 'SV-MO'),
(2883, 'SV', 'San Miguel', 'SV-SM'),
(2884, 'SV', 'San Salvador', 'SV-SS'),
(2885, 'SV', 'San Vicente', 'SV-SV'),
(2886, 'SV', 'Santa Ana', 'SV-SA'),
(2887, 'SV', 'Sonsonate', 'SV-SO'),
(2888, 'SV', 'Usulutan', 'SV-US'),
(2889, 'SX', 'Sint Maarten (Dutch Part)', '-'),
(2890, 'SY', 'Al Hasakah', 'SY-HA'),
(2891, 'SY', 'Al Ladhiqiyah', 'SY-LA'),
(2892, 'SY', 'Al Qunaytirah', 'SY-QU'),
(2893, 'SY', 'Ar Raqqah', 'SY-RA'),
(2894, 'SY', 'As Suwayda', 'SY-SU'),
(2895, 'SY', 'Dara', 'SY-DR'),
(2896, 'SY', 'Dayr az Zawr', 'SY-DY'),
(2897, 'SY', 'Dimashq', 'SY-DI'),
(2898, 'SY', 'Halab', 'SY-HL'),
(2899, 'SY', 'Hamah', 'SY-HM'),
(2900, 'SY', 'Hims', 'SY-HI'),
(2901, 'SY', 'Idlib', 'SY-ID'),
(2902, 'SY', 'Rif Dimashq', 'SY-RD'),
(2903, 'SY', 'Tartus', 'SY-TA'),
(2904, 'SZ', 'Hhohho', 'SZ-HH'),
(2905, 'SZ', 'Lubombo', 'SZ-LU'),
(2906, 'SZ', 'Manzini', 'SZ-MA'),
(2907, 'TC', 'Turks and Caicos Islands', '-'),
(2908, 'TD', 'Guera', 'TD-GR'),
(2909, 'TD', 'Logone-Occidental', 'TD-LO'),
(2910, 'TD', 'Mayo-Kebbi-Est', 'TD-ME'),
(2911, 'TD', 'Ouaddai', 'TD-OD'),
(2912, 'TD', 'Ville de Ndjamena', 'TD-ND'),
(2913, 'TD', 'Wadi Fira', 'TD-WF'),
(2914, 'TF', 'French Southern Territories', '-'),
(2915, 'TG', 'Centrale', 'TG-C'),
(2916, 'TG', 'Kara', 'TG-K'),
(2917, 'TG', 'Maritime', 'TG-M'),
(2918, 'TG', 'Plateaux', 'TG-P'),
(2919, 'TH', 'Amnat Charoen', 'TH-37'),
(2920, 'TH', 'Ang Thong', 'TH-15'),
(2921, 'TH', 'Bueng Kan', 'TH-38'),
(2922, 'TH', 'Buri Ram', 'TH-31'),
(2923, 'TH', 'Chachoengsao', 'TH-24'),
(2924, 'TH', 'Chai Nat', 'TH-18'),
(2925, 'TH', 'Chaiyaphum', 'TH-36'),
(2926, 'TH', 'Chanthaburi', 'TH-22'),
(2927, 'TH', 'Chiang Mai', 'TH-50'),
(2928, 'TH', 'Chiang Rai', 'TH-57'),
(2929, 'TH', 'Chon Buri', 'TH-20'),
(2930, 'TH', 'Chumphon', 'TH-86'),
(2931, 'TH', 'Kalasin', 'TH-46'),
(2932, 'TH', 'Kamphaeng Phet', 'TH-62'),
(2933, 'TH', 'Kanchanaburi', 'TH-71'),
(2934, 'TH', 'Khon Kaen', 'TH-40'),
(2935, 'TH', 'Krabi', 'TH-81'),
(2936, 'TH', 'Krung Thep Maha Nakhon', 'TH-10'),
(2937, 'TH', 'Lampang', 'TH-52'),
(2938, 'TH', 'Lamphun', 'TH-51'),
(2939, 'TH', 'Loei', 'TH-42'),
(2940, 'TH', 'Lop Buri', 'TH-16'),
(2941, 'TH', 'Mae Hong Son', 'TH-58'),
(2942, 'TH', 'Maha Sarakham', 'TH-44'),
(2943, 'TH', 'Mukdahan', 'TH-49'),
(2944, 'TH', 'Nakhon Nayok', 'TH-26'),
(2945, 'TH', 'Nakhon Pathom', 'TH-73'),
(2946, 'TH', 'Nakhon Phanom', 'TH-48'),
(2947, 'TH', 'Nakhon Ratchasima', 'TH-30'),
(2948, 'TH', 'Nakhon Sawan', 'TH-60'),
(2949, 'TH', 'Nakhon Si Thammarat', 'TH-80'),
(2950, 'TH', 'Nan', 'TH-55'),
(2951, 'TH', 'Narathiwat', 'TH-96'),
(2952, 'TH', 'Nong Bua Lam Phu', 'TH-39'),
(2953, 'TH', 'Nong Khai', 'TH-43'),
(2954, 'TH', 'Nonthaburi', 'TH-12'),
(2955, 'TH', 'Pathum Thani', 'TH-13'),
(2956, 'TH', 'Pattani', 'TH-94'),
(2957, 'TH', 'Phangnga', 'TH-82'),
(2958, 'TH', 'Phatthalung', 'TH-93'),
(2959, 'TH', 'Phayao', 'TH-56'),
(2960, 'TH', 'Phetchabun', 'TH-67'),
(2961, 'TH', 'Phetchaburi', 'TH-76'),
(2962, 'TH', 'Phichit', 'TH-66'),
(2963, 'TH', 'Phitsanulok', 'TH-65'),
(2964, 'TH', 'Phra Nakhon Si Ayutthaya', 'TH-14'),
(2965, 'TH', 'Phrae', 'TH-54'),
(2966, 'TH', 'Phuket', 'TH-83'),
(2967, 'TH', 'Prachin Buri', 'TH-25'),
(2968, 'TH', 'Prachuap Khiri Khan', 'TH-77'),
(2969, 'TH', 'Ranong', 'TH-85'),
(2970, 'TH', 'Ratchaburi', 'TH-70'),
(2971, 'TH', 'Rayong', 'TH-21'),
(2972, 'TH', 'Roi Et', 'TH-45'),
(2973, 'TH', 'Sa Kaeo', 'TH-27'),
(2974, 'TH', 'Sakon Nakhon', 'TH-47'),
(2975, 'TH', 'Samut Prakan', 'TH-11'),
(2976, 'TH', 'Samut Sakhon', 'TH-74'),
(2977, 'TH', 'Samut Songkhram', 'TH-75'),
(2978, 'TH', 'Saraburi', 'TH-19'),
(2979, 'TH', 'Satun', 'TH-91'),
(2980, 'TH', 'Si Sa Ket', 'TH-33'),
(2981, 'TH', 'Sing Buri', 'TH-17'),
(2982, 'TH', 'Songkhla', 'TH-90'),
(2983, 'TH', 'Sukhothai', 'TH-64'),
(2984, 'TH', 'Suphan Buri', 'TH-72'),
(2985, 'TH', 'Surat Thani', 'TH-84'),
(2986, 'TH', 'Surin', 'TH-32'),
(2987, 'TH', 'Tak', 'TH-63'),
(2988, 'TH', 'Trang', 'TH-92'),
(2989, 'TH', 'Trat', 'TH-23'),
(2990, 'TH', 'Ubon Ratchathani', 'TH-34'),
(2991, 'TH', 'Udon Thani', 'TH-41'),
(2992, 'TH', 'Uthai Thani', 'TH-61'),
(2993, 'TH', 'Uttaradit', 'TH-53'),
(2994, 'TH', 'Yala', 'TH-95'),
(2995, 'TH', 'Yasothon', 'TH-35'),
(2996, 'TJ', 'Dushanbe', 'TJ-DU'),
(2997, 'TJ', 'Khatlon', 'TJ-KT'),
(2998, 'TJ', 'Nohiyahoi Tobei Jumhuri', 'TJ-RA'),
(2999, 'TJ', 'Sughd', 'TJ-SU'),
(3000, 'TK', 'Tokelau', '-'),
(3001, 'TL', 'Ainaro', 'TL-AN'),
(3002, 'TL', 'Cova Lima', 'TL-CO'),
(3003, 'TL', 'Dili', 'TL-DI'),
(3004, 'TM', 'Ahal', 'TM-A'),
(3005, 'TM', 'Balkan', 'TM-B'),
(3006, 'TM', 'Dasoguz', 'TM-D'),
(3007, 'TM', 'Lebap', 'TM-L'),
(3008, 'TM', 'Mary', 'TM-M'),
(3009, 'TN', 'Beja', 'TN-31'),
(3010, 'TN', 'Ben Arous', 'TN-13'),
(3011, 'TN', 'Bizerte', 'TN-23'),
(3012, 'TN', 'Gabes', 'TN-81'),
(3013, 'TN', 'Gafsa', 'TN-71'),
(3014, 'TN', 'Jendouba', 'TN-32'),
(3015, 'TN', 'Kairouan', 'TN-41'),
(3016, 'TN', 'Kasserine', 'TN-42'),
(3017, 'TN', 'Kebili', 'TN-73'),
(3018, 'TN', 'LAriana', 'TN-12'),
(3019, 'TN', 'La Manouba', 'TN-14'),
(3020, 'TN', 'Le Kef', 'TN-33'),
(3021, 'TN', 'Mahdia', 'TN-53'),
(3022, 'TN', 'Medenine', 'TN-82'),
(3023, 'TN', 'Monastir', 'TN-52'),
(3024, 'TN', 'Nabeul', 'TN-21'),
(3025, 'TN', 'Sfax', 'TN-61'),
(3026, 'TN', 'Sidi Bouzid', 'TN-43'),
(3027, 'TN', 'Siliana', 'TN-34'),
(3028, 'TN', 'Sousse', 'TN-51'),
(3029, 'TN', 'Tataouine', 'TN-83'),
(3030, 'TN', 'Tozeur', 'TN-72'),
(3031, 'TN', 'Tunis', 'TN-11'),
(3032, 'TN', 'Zaghouan', 'TN-22'),
(3033, 'TO', 'Niuas', 'TO-03'),
(3034, 'TO', 'Tongatapu', 'TO-04'),
(3035, 'TR', 'Adana', 'TR-01'),
(3036, 'TR', 'Adiyaman', 'TR-02'),
(3037, 'TR', 'Afyonkarahisar', 'TR-03'),
(3038, 'TR', 'Agri', 'TR-04'),
(3039, 'TR', 'Aksaray', 'TR-68'),
(3040, 'TR', 'Amasya', 'TR-05'),
(3041, 'TR', 'Ankara', 'TR-06'),
(3042, 'TR', 'Antalya', 'TR-07'),
(3043, 'TR', 'Ardahan', 'TR-75'),
(3044, 'TR', 'Artvin', 'TR-08'),
(3045, 'TR', 'Aydin', 'TR-09'),
(3046, 'TR', 'Balikesir', 'TR-10'),
(3047, 'TR', 'Bartin', 'TR-74'),
(3048, 'TR', 'Batman', 'TR-72'),
(3049, 'TR', 'Bayburt', 'TR-69'),
(3050, 'TR', 'Bilecik', 'TR-11'),
(3051, 'TR', 'Bingol', 'TR-12'),
(3052, 'TR', 'Bitlis', 'TR-13'),
(3053, 'TR', 'Bolu', 'TR-14'),
(3054, 'TR', 'Burdur', 'TR-15'),
(3055, 'TR', 'Bursa', 'TR-16'),
(3056, 'TR', 'Canakkale', 'TR-17'),
(3057, 'TR', 'Cankiri', 'TR-18'),
(3058, 'TR', 'Corum', 'TR-19'),
(3059, 'TR', 'Denizli', 'TR-20'),
(3060, 'TR', 'Diyarbakir', 'TR-21'),
(3061, 'TR', 'Duzce', 'TR-81'),
(3062, 'TR', 'Edirne', 'TR-22'),
(3063, 'TR', 'Elazig', 'TR-23'),
(3064, 'TR', 'Erzincan', 'TR-24'),
(3065, 'TR', 'Erzurum', 'TR-25'),
(3066, 'TR', 'Eskisehir', 'TR-26'),
(3067, 'TR', 'Gaziantep', 'TR-27'),
(3068, 'TR', 'Giresun', 'TR-28'),
(3069, 'TR', 'Gumushane', 'TR-29'),
(3070, 'TR', 'Hakkari', 'TR-30'),
(3071, 'TR', 'Hatay', 'TR-31'),
(3072, 'TR', 'Igdir', 'TR-76'),
(3073, 'TR', 'Isparta', 'TR-32'),
(3074, 'TR', 'Istanbul', 'TR-34'),
(3075, 'TR', 'Izmir', 'TR-35'),
(3076, 'TR', 'Kahramanmaras', 'TR-46'),
(3077, 'TR', 'Karabuk', 'TR-78'),
(3078, 'TR', 'Karaman', 'TR-70'),
(3079, 'TR', 'Kars', 'TR-36'),
(3080, 'TR', 'Kastamonu', 'TR-37'),
(3081, 'TR', 'Kayseri', 'TR-38'),
(3082, 'TR', 'Kilis', 'TR-79'),
(3083, 'TR', 'Kirikkale', 'TR-71'),
(3084, 'TR', 'Kirklareli', 'TR-39'),
(3085, 'TR', 'Kirsehir', 'TR-40'),
(3086, 'TR', 'Kocaeli', 'TR-41'),
(3087, 'TR', 'Konya', 'TR-42'),
(3088, 'TR', 'Kutahya', 'TR-43'),
(3089, 'TR', 'Malatya', 'TR-44'),
(3090, 'TR', 'Manisa', 'TR-45'),
(3091, 'TR', 'Mardin', 'TR-47'),
(3092, 'TR', 'Mersin', 'TR-33'),
(3093, 'TR', 'Mugla', 'TR-48'),
(3094, 'TR', 'Mus', 'TR-49'),
(3095, 'TR', 'Nevsehir', 'TR-50'),
(3096, 'TR', 'Nigde', 'TR-51'),
(3097, 'TR', 'Ordu', 'TR-52'),
(3098, 'TR', 'Osmaniye', 'TR-80'),
(3099, 'TR', 'Rize', 'TR-53'),
(3100, 'TR', 'Sakarya', 'TR-54'),
(3101, 'TR', 'Samsun', 'TR-55'),
(3102, 'TR', 'Sanliurfa', 'TR-63'),
(3103, 'TR', 'Siirt', 'TR-56'),
(3104, 'TR', 'Sinop', 'TR-57'),
(3105, 'TR', 'Sirnak', 'TR-73'),
(3106, 'TR', 'Sivas', 'TR-58'),
(3107, 'TR', 'Tekirdag', 'TR-59'),
(3108, 'TR', 'Tokat', 'TR-60'),
(3109, 'TR', 'Trabzon', 'TR-61'),
(3110, 'TR', 'Tunceli', 'TR-62'),
(3111, 'TR', 'Usak', 'TR-64'),
(3112, 'TR', 'Van', 'TR-65'),
(3113, 'TR', 'Yalova', 'TR-77'),
(3114, 'TR', 'Yozgat', 'TR-66'),
(3115, 'TR', 'Zonguldak', 'TR-67'),
(3116, 'TT', 'Arima', 'TT-ARI'),
(3117, 'TT', 'Chaguanas', 'TT-CHA'),
(3118, 'TT', 'Couva-Tabaquite-Talparo', 'TT-CTT'),
(3119, 'TT', 'Diego Martin', 'TT-DMN'),
(3120, 'TT', 'Mayaro-Rio Claro', 'TT-MRC'),
(3121, 'TT', 'Penal-Debe', 'TT-PED'),
(3122, 'TT', 'Point Fortin', 'TT-PTF'),
(3123, 'TT', 'Port of Spain', 'TT-POS'),
(3124, 'TT', 'Princes Town', 'TT-PRT'),
(3125, 'TT', 'San Fernando', 'TT-SFO'),
(3126, 'TT', 'San Juan-Laventille', 'TT-SJL'),
(3127, 'TT', 'Sangre Grande', 'TT-SGE'),
(3128, 'TT', 'Siparia', 'TT-SIP'),
(3129, 'TT', 'Tobago', 'TT-TOB'),
(3130, 'TT', 'Tunapuna-Piarco', 'TT-TUP'),
(3131, 'TV', 'Funafuti', 'TV-FUN'),
(3132, 'TW', 'Changhua', 'TW-CHA'),
(3133, 'TW', 'Chiayi', 'TW-CYQ'),
(3134, 'TW', 'Hsinchu', 'TW-HSQ'),
(3135, 'TW', 'Hualien', 'TW-HUA'),
(3136, 'TW', 'Kaohsiung', 'TW-KHH'),
(3137, 'TW', 'Keelung', 'TW-KEE'),
(3138, 'TW', 'Kinmen', 'TW-KIN'),
(3139, 'TW', 'Lienchiang', 'TW-LIE'),
(3140, 'TW', 'Miaoli', 'TW-MIA'),
(3141, 'TW', 'Nantou', 'TW-NAN'),
(3142, 'TW', 'New Taipei', 'TW-NWT'),
(3143, 'TW', 'Penghu', 'TW-PEN'),
(3144, 'TW', 'Pingtung', 'TW-PIF'),
(3145, 'TW', 'Taichung', 'TW-TXG'),
(3146, 'TW', 'Tainan', 'TW-TNN'),
(3147, 'TW', 'Taipei', 'TW-TPE'),
(3148, 'TW', 'Taitung', 'TW-TTT'),
(3149, 'TW', 'Taoyuan', 'TW-TAO'),
(3150, 'TW', 'Yilan', 'TW-ILA'),
(3151, 'TW', 'Yunlin', 'TW-YUN'),
(3152, 'TZ', 'Arusha', 'TZ-01'),
(3153, 'TZ', 'Dar es Salaam', 'TZ-02'),
(3154, 'TZ', 'Dodoma', 'TZ-03'),
(3155, 'TZ', 'Geita', 'TZ-27'),
(3156, 'TZ', 'Iringa', 'TZ-04'),
(3157, 'TZ', 'Kagera', 'TZ-05'),
(3158, 'TZ', 'Kaskazini Unguja', 'TZ-07'),
(3159, 'TZ', 'Katavi', 'TZ-28'),
(3160, 'TZ', 'Kigoma', 'TZ-08'),
(3161, 'TZ', 'Kilimanjaro', 'TZ-09'),
(3162, 'TZ', 'Kusini Unguja', 'TZ-11'),
(3163, 'TZ', 'Lindi', 'TZ-12'),
(3164, 'TZ', 'Manyara', 'TZ-26'),
(3165, 'TZ', 'Mara', 'TZ-13'),
(3166, 'TZ', 'Mbeya', 'TZ-14'),
(3167, 'TZ', 'Mjini Magharibi', 'TZ-15'),
(3168, 'TZ', 'Morogoro', 'TZ-16'),
(3169, 'TZ', 'Mtwara', 'TZ-17'),
(3170, 'TZ', 'Mwanza', 'TZ-18'),
(3171, 'TZ', 'Njombe', 'TZ-29'),
(3172, 'TZ', 'Pwani', 'TZ-19'),
(3173, 'TZ', 'Rukwa', 'TZ-20'),
(3174, 'TZ', 'Ruvuma', 'TZ-21'),
(3175, 'TZ', 'Shinyanga', 'TZ-22'),
(3176, 'TZ', 'Simiyu', 'TZ-30'),
(3177, 'TZ', 'Singida', 'TZ-23'),
(3178, 'TZ', 'Songwe', 'TZ-31'),
(3179, 'TZ', 'Tabora', 'TZ-24'),
(3180, 'TZ', 'Tanga', 'TZ-25'),
(3181, 'UA', 'Avtonomna Respublika Krym', 'UA-43'),
(3182, 'UA', 'Cherkaska oblast', 'UA-71'),
(3183, 'UA', 'Chernihivska oblast', 'UA-74'),
(3184, 'UA', 'Chernivetska oblast', 'UA-77'),
(3185, 'UA', 'Dnipropetrovska oblast', 'UA-12'),
(3186, 'UA', 'Donetska oblast', 'UA-14'),
(3187, 'UA', 'Ivano-Frankivska oblast', 'UA-26'),
(3188, 'UA', 'Kharkivska oblast', 'UA-63'),
(3189, 'UA', 'Khersonska oblast', 'UA-65'),
(3190, 'UA', 'Khmelnytska oblast', 'UA-68'),
(3191, 'UA', 'Kirovohradska oblast', 'UA-35'),
(3192, 'UA', 'Kyiv', 'UA-30'),
(3193, 'UA', 'Kyivska oblast', 'UA-32'),
(3194, 'UA', 'Luhanska oblast', 'UA-09'),
(3195, 'UA', 'Lvivska oblast', 'UA-46'),
(3196, 'UA', 'Mykolaivska oblast', 'UA-48'),
(3197, 'UA', 'Odeska oblast', 'UA-51'),
(3198, 'UA', 'Poltavska oblast', 'UA-53'),
(3199, 'UA', 'Rivnenska oblast', 'UA-56'),
(3200, 'UA', 'Sevastopol', 'UA-40'),
(3201, 'UA', 'Sumska oblast', 'UA-59'),
(3202, 'UA', 'Ternopilska oblast', 'UA-61'),
(3203, 'UA', 'Vinnytska oblast', 'UA-05'),
(3204, 'UA', 'Volynska oblast', 'UA-07'),
(3205, 'UA', 'Zakarpatska oblast', 'UA-21'),
(3206, 'UA', 'Zaporizka oblast', 'UA-23'),
(3207, 'UA', 'Zhytomyrska oblast', 'UA-18'),
(3208, 'UG', 'Alebtong', 'UG-323'),
(3209, 'UG', 'Amuru', 'UG-316'),
(3210, 'UG', 'Arua', 'UG-303'),
(3211, 'UG', 'Bugiri', 'UG-201'),
(3212, 'UG', 'Buikwe', 'UG-117'),
(3213, 'UG', 'Bukedea', 'UG-219'),
(3214, 'UG', 'Buvuma', 'UG-120'),
(3215, 'UG', 'Gulu', 'UG-304'),
(3216, 'UG', 'Hoima', 'UG-403'),
(3217, 'UG', 'Iganga', 'UG-203'),
(3218, 'UG', 'Jinja', 'UG-204'),
(3219, 'UG', 'Kabale', 'UG-404'),
(3220, 'UG', 'Kabarole', 'UG-405'),
(3221, 'UG', 'Kalangala', 'UG-101'),
(3222, 'UG', 'Kaliro', 'UG-222'),
(3223, 'UG', 'Kalungu', 'UG-122'),
(3224, 'UG', 'Kampala', 'UG-102'),
(3225, 'UG', 'Kamuli', 'UG-205'),
(3226, 'UG', 'Kamwenge', 'UG-413'),
(3227, 'UG', 'Kapchorwa', 'UG-206'),
(3228, 'UG', 'Kasese', 'UG-406'),
(3229, 'UG', 'Kayunga', 'UG-112'),
(3230, 'UG', 'Kibaale', 'UG-407'),
(3231, 'UG', 'Kiboga', 'UG-103'),
(3232, 'UG', 'Kiruhura', 'UG-419'),
(3233, 'UG', 'Kisoro', 'UG-408'),
(3234, 'UG', 'Kitgum', 'UG-305'),
(3235, 'UG', 'Kyenjojo', 'UG-415'),
(3236, 'UG', 'Lira', 'UG-307'),
(3237, 'UG', 'Luwero', 'UG-104'),
(3238, 'UG', 'Masaka', 'UG-105'),
(3239, 'UG', 'Masindi', 'UG-409'),
(3240, 'UG', 'Mayuge', 'UG-214'),
(3241, 'UG', 'Mbale', 'UG-209'),
(3242, 'UG', 'Mbarara', 'UG-410'),
(3243, 'UG', 'Mitooma', 'UG-423'),
(3244, 'UG', 'Mityana', 'UG-115'),
(3245, 'UG', 'Mpigi', 'UG-106'),
(3246, 'UG', 'Mubende', 'UG-107'),
(3247, 'UG', 'Mukono', 'UG-108'),
(3248, 'UG', 'Nakaseke', 'UG-116'),
(3249, 'UG', 'Nakasongola', 'UG-109'),
(3250, 'UG', 'Ntungamo', 'UG-411'),
(3251, 'UG', 'Oyam', 'UG-321'),
(3252, 'UG', 'Pallisa', 'UG-210'),
(3253, 'UG', 'Rukungiri', 'UG-412'),
(3254, 'UG', 'Sironko', 'UG-215'),
(3255, 'UG', 'Soroti', 'UG-211'),
(3256, 'UG', 'Wakiso', 'UG-113'),
(3257, 'UM', 'Palmyra Atoll', 'UM-95'),
(3258, 'US', 'Alabama', 'US-AL'),
(3259, 'US', 'Alaska', 'US-AK'),
(3260, 'US', 'Arizona', 'US-AZ'),
(3261, 'US', 'Arkansas', 'US-AR'),
(3262, 'US', 'California', 'US-CA'),
(3263, 'US', 'Colorado', 'US-CO'),
(3264, 'US', 'Connecticut', 'US-CT'),
(3265, 'US', 'Delaware', 'US-DE'),
(3266, 'US', 'District of Columbia', 'US-DC'),
(3267, 'US', 'Florida', 'US-FL'),
(3268, 'US', 'Georgia', 'US-GA'),
(3269, 'US', 'Hawaii', 'US-HI'),
(3270, 'US', 'Idaho', 'US-ID'),
(3271, 'US', 'Illinois', 'US-IL'),
(3272, 'US', 'Indiana', 'US-IN'),
(3273, 'US', 'Iowa', 'US-IA'),
(3274, 'US', 'Kansas', 'US-KS'),
(3275, 'US', 'Kentucky', 'US-KY'),
(3276, 'US', 'Louisiana', 'US-LA'),
(3277, 'US', 'Maine', 'US-ME'),
(3278, 'US', 'Maryland', 'US-MD'),
(3279, 'US', 'Massachusetts', 'US-MA'),
(3280, 'US', 'Michigan', 'US-MI'),
(3281, 'US', 'Minnesota', 'US-MN'),
(3282, 'US', 'Mississippi', 'US-MS'),
(3283, 'US', 'Missouri', 'US-MO'),
(3284, 'US', 'Montana', 'US-MT'),
(3285, 'US', 'Nebraska', 'US-NE'),
(3286, 'US', 'Nevada', 'US-NV'),
(3287, 'US', 'New Hampshire', 'US-NH'),
(3288, 'US', 'New Jersey', 'US-NJ'),
(3289, 'US', 'New Mexico', 'US-NM'),
(3290, 'US', 'New York', 'US-NY'),
(3291, 'US', 'North Carolina', 'US-NC'),
(3292, 'US', 'North Dakota', 'US-ND'),
(3293, 'US', 'Ohio', 'US-OH'),
(3294, 'US', 'Oklahoma', 'US-OK'),
(3295, 'US', 'Oregon', 'US-OR'),
(3296, 'US', 'Pennsylvania', 'US-PA'),
(3297, 'US', 'Rhode Island', 'US-RI'),
(3298, 'US', 'South Carolina', 'US-SC'),
(3299, 'US', 'South Dakota', 'US-SD'),
(3300, 'US', 'Tennessee', 'US-TN'),
(3301, 'US', 'Texas', 'US-TX'),
(3302, 'US', 'Utah', 'US-UT'),
(3303, 'US', 'Vermont', 'US-VT'),
(3304, 'US', 'Virginia', 'US-VA'),
(3305, 'US', 'Washington', 'US-WA'),
(3306, 'US', 'West Virginia', 'US-WV'),
(3307, 'US', 'Wisconsin', 'US-WI'),
(3308, 'US', 'Wyoming', 'US-WY'),
(3309, 'UY', 'Artigas', 'UY-AR'),
(3310, 'UY', 'Canelones', 'UY-CA'),
(3311, 'UY', 'Cerro Largo', 'UY-CL'),
(3312, 'UY', 'Colonia', 'UY-CO'),
(3313, 'UY', 'Durazno', 'UY-DU'),
(3314, 'UY', 'Flores', 'UY-FS'),
(3315, 'UY', 'Florida', 'UY-FD'),
(3316, 'UY', 'Lavalleja', 'UY-LA'),
(3317, 'UY', 'Maldonado', 'UY-MA'),
(3318, 'UY', 'Montevideo', 'UY-MO'),
(3319, 'UY', 'Paysandu', 'UY-PA'),
(3320, 'UY', 'Rio Negro', 'UY-RN'),
(3321, 'UY', 'Rivera', 'UY-RV'),
(3322, 'UY', 'Rocha', 'UY-RO'),
(3323, 'UY', 'Salto', 'UY-SA'),
(3324, 'UY', 'San Jose', 'UY-SJ'),
(3325, 'UY', 'Soriano', 'UY-SO'),
(3326, 'UY', 'Tacuarembo', 'UY-TA'),
(3327, 'UY', 'Treinta y Tres', 'UY-TT'),
(3328, 'UZ', 'Andijon', 'UZ-AN'),
(3329, 'UZ', 'Buxoro', 'UZ-BU'),
(3330, 'UZ', 'Fargona', 'UZ-FA'),
(3331, 'UZ', 'Jizzax', 'UZ-JI'),
(3332, 'UZ', 'Namangan', 'UZ-NG'),
(3333, 'UZ', 'Navoiy', 'UZ-NW'),
(3334, 'UZ', 'Qashqadaryo', 'UZ-QA'),
(3335, 'UZ', 'Qoraqalpogiston Respublikasi', 'UZ-QR'),
(3336, 'UZ', 'Samarqand', 'UZ-SA'),
(3337, 'UZ', 'Sirdaryo', 'UZ-SI'),
(3338, 'UZ', 'Surxondaryo', 'UZ-SU'),
(3339, 'UZ', 'Toshkent', 'UZ-TK'),
(3340, 'UZ', 'Xorazm', 'UZ-XO'),
(3341, 'VA', 'Vatican City', '-'),
(3342, 'VC', 'Charlotte', 'VC-01'),
(3343, 'VC', 'Grenadines', 'VC-06'),
(3344, 'VC', 'Saint George', 'VC-04'),
(3345, 'VC', 'Saint Patrick', 'VC-05'),
(3346, 'VE', 'Amazonas', 'VE-Z'),
(3347, 'VE', 'Anzoategui', 'VE-B'),
(3348, 'VE', 'Apure', 'VE-C'),
(3349, 'VE', 'Aragua', 'VE-D'),
(3350, 'VE', 'Barinas', 'VE-E'),
(3351, 'VE', 'Bolivar', 'VE-F'),
(3352, 'VE', 'Carabobo', 'VE-G'),
(3353, 'VE', 'Cojedes', 'VE-H'),
(3354, 'VE', 'Delta Amacuro', 'VE-Y'),
(3355, 'VE', 'Distrito Capital', 'VE-A'),
(3356, 'VE', 'Falcon', 'VE-I'),
(3357, 'VE', 'Guarico', 'VE-J'),
(3358, 'VE', 'La Guaira', 'VE-X'),
(3359, 'VE', 'Lara', 'VE-K'),
(3360, 'VE', 'Merida', 'VE-L'),
(3361, 'VE', 'Miranda', 'VE-M'),
(3362, 'VE', 'Monagas', 'VE-N'),
(3363, 'VE', 'Nueva Esparta', 'VE-O'),
(3364, 'VE', 'Portuguesa', 'VE-P'),
(3365, 'VE', 'Sucre', 'VE-R'),
(3366, 'VE', 'Tachira', 'VE-S'),
(3367, 'VE', 'Trujillo', 'VE-T'),
(3368, 'VE', 'Yaracuy', 'VE-U'),
(3369, 'VE', 'Zulia', 'VE-V'),
(3370, 'VG', 'Virgin Islands, British', '-'),
(3371, 'VI', 'Virgin Islands, U.S.', '-'),
(3372, 'VN', 'An Giang', 'VN-44'),
(3373, 'VN', 'Ba Ria - Vung Tau', 'VN-43'),
(3374, 'VN', 'Bac Giang', 'VN-54'),
(3375, 'VN', 'Bac Kan', 'VN-53'),
(3376, 'VN', 'Bac Lieu', 'VN-55'),
(3377, 'VN', 'Bac Ninh', 'VN-56'),
(3378, 'VN', 'Ben Tre', 'VN-50'),
(3379, 'VN', 'Binh Dinh', 'VN-31'),
(3380, 'VN', 'Binh Duong', 'VN-57'),
(3381, 'VN', 'Binh Phuoc', 'VN-58'),
(3382, 'VN', 'Binh Thuan', 'VN-40'),
(3383, 'VN', 'Ca Mau', 'VN-59'),
(3384, 'VN', 'Can Tho', 'VN-CT'),
(3385, 'VN', 'Cao Bang', 'VN-04'),
(3386, 'VN', 'Da Nang', 'VN-DN'),
(3387, 'VN', 'Dak Lak', 'VN-33'),
(3388, 'VN', 'Dak Nong', 'VN-72'),
(3389, 'VN', 'Dien Bien', 'VN-71'),
(3390, 'VN', 'Dong Nai', 'VN-39'),
(3391, 'VN', 'Dong Thap', 'VN-45'),
(3392, 'VN', 'Gia Lai', 'VN-30'),
(3393, 'VN', 'Ha Giang', 'VN-03'),
(3394, 'VN', 'Ha Nam', 'VN-63'),
(3395, 'VN', 'Ha Noi', 'VN-HN'),
(3396, 'VN', 'Ha Tinh', 'VN-23'),
(3397, 'VN', 'Hai Duong', 'VN-61'),
(3398, 'VN', 'Hai Phong', 'VN-HP'),
(3399, 'VN', 'Ho Chi Minh', 'VN-SG'),
(3400, 'VN', 'Hoa Binh', 'VN-14'),
(3401, 'VN', 'Hung Yen', 'VN-66'),
(3402, 'VN', 'Khanh Hoa', 'VN-34'),
(3403, 'VN', 'Kien Giang', 'VN-47'),
(3404, 'VN', 'Kon Tum', 'VN-28'),
(3405, 'VN', 'Lai Chau', 'VN-01'),
(3406, 'VN', 'Lam Dong', 'VN-35'),
(3407, 'VN', 'Lang Son', 'VN-09'),
(3408, 'VN', 'Lao Cai', 'VN-02'),
(3409, 'VN', 'Long An', 'VN-41'),
(3410, 'VN', 'Nam Dinh', 'VN-67'),
(3411, 'VN', 'Nghe An', 'VN-22'),
(3412, 'VN', 'Ninh Binh', 'VN-18'),
(3413, 'VN', 'Ninh Thuan', 'VN-36'),
(3414, 'VN', 'Phu Tho', 'VN-68'),
(3415, 'VN', 'Phu Yen', 'VN-32'),
(3416, 'VN', 'Quang Binh', 'VN-24'),
(3417, 'VN', 'Quang Nam', 'VN-27'),
(3418, 'VN', 'Quang Ngai', 'VN-29'),
(3419, 'VN', 'Quang Ninh', 'VN-13'),
(3420, 'VN', 'Quang Tri', 'VN-25'),
(3421, 'VN', 'Soc Trang', 'VN-52'),
(3422, 'VN', 'Son La', 'VN-05'),
(3423, 'VN', 'Tay Ninh', 'VN-37'),
(3424, 'VN', 'Thai Binh', 'VN-20'),
(3425, 'VN', 'Thai Nguyen', 'VN-69'),
(3426, 'VN', 'Thanh Hoa', 'VN-21'),
(3427, 'VN', 'Thua Thien-Hue', 'VN-26'),
(3428, 'VN', 'Tien Giang', 'VN-46'),
(3429, 'VN', 'Tra Vinh', 'VN-51'),
(3430, 'VN', 'Tuyen Quang', 'VN-07'),
(3431, 'VN', 'Vinh Long', 'VN-49'),
(3432, 'VN', 'Vinh Phuc', 'VN-70'),
(3433, 'VN', 'Yen Bai', 'VN-06'),
(3434, 'VU', 'Shefa', 'VU-SEE'),
(3435, 'VU', 'Tafea', 'VU-TAE'),
(3436, 'VU', 'Torba', 'VU-TOB'),
(3437, 'WF', 'Sigave', 'WF-SG'),
(3438, 'WF', 'Uvea', 'WF-UV'),
(3439, 'WS', 'Atua', 'WS-AT'),
(3440, 'WS', 'Faasaleleaga', 'WS-FA'),
(3441, 'WS', 'Tuamasaga', 'WS-TU'),
(3442, 'YE', 'Adan', 'YE-AD'),
(3443, 'YE', 'Amran', 'YE-AM'),
(3444, 'YE', 'Abyan', 'YE-AB'),
(3445, 'YE', 'Ad Dali', 'YE-DA'),
(3446, 'YE', 'Al Bayda', 'YE-BA'),
(3447, 'YE', 'Al Hudaydah', 'YE-HU'),
(3448, 'YE', 'Al Mahrah', 'YE-MR'),
(3449, 'YE', 'Amanat al Asimah', 'YE-SA'),
(3450, 'YE', 'Dhamar', 'YE-DH'),
(3451, 'YE', 'Hadramawt', 'YE-HD'),
(3452, 'YE', 'Hajjah', 'YE-HJ'),
(3453, 'YE', 'Ibb', 'YE-IB'),
(3454, 'YE', 'Lahij', 'YE-LA'),
(3455, 'YE', 'Marib', 'YE-MA'),
(3456, 'YE', 'Sadah', 'YE-SD'),
(3457, 'YE', 'Sana', 'YE-SN'),
(3458, 'YE', 'Shabwah', 'YE-SH'),
(3459, 'YE', 'Taizz', 'YE-TA'),
(3460, 'YT', 'Bandraboua', '-'),
(3461, 'YT', 'Bandrele', '-'),
(3462, 'YT', 'Mamoudzou', '-'),
(3463, 'YT', 'Ouangani', '-'),
(3464, 'YT', 'Pamandzi', '-'),
(3465, 'YT', 'Sada', '-'),
(3466, 'ZA', 'Eastern Cape', 'ZA-EC'),
(3467, 'ZA', 'Free State', 'ZA-FS'),
(3468, 'ZA', 'Gauteng', 'ZA-GP'),
(3469, 'ZA', 'Kwazulu-Natal', 'ZA-KZN'),
(3470, 'ZA', 'Limpopo', 'ZA-LP'),
(3471, 'ZA', 'Mpumalanga', 'ZA-MP'),
(3472, 'ZA', 'North-West', 'ZA-NW'),
(3473, 'ZA', 'Northern Cape', 'ZA-NC'),
(3474, 'ZA', 'Western Cape', 'ZA-WC'),
(3475, 'ZM', 'Central', 'ZM-02'),
(3476, 'ZM', 'Copperbelt', 'ZM-08'),
(3477, 'ZM', 'Eastern', 'ZM-03'),
(3478, 'ZM', 'Luapula', 'ZM-04'),
(3479, 'ZM', 'Lusaka', 'ZM-09'),
(3480, 'ZM', 'Muchinga', 'ZM-10'),
(3481, 'ZM', 'North-Western', 'ZM-06'),
(3482, 'ZM', 'Northern', 'ZM-05'),
(3483, 'ZM', 'Southern', 'ZM-07'),
(3484, 'ZM', 'Western', 'ZM-01'),
(3485, 'ZW', 'Bulawayo', 'ZW-BU'),
(3486, 'ZW', 'Harare', 'ZW-HA'),
(3487, 'ZW', 'Manicaland', 'ZW-MA'),
(3488, 'ZW', 'Mashonaland Central', 'ZW-MC'),
(3489, 'ZW', 'Mashonaland East', 'ZW-ME'),
(3490, 'ZW', 'Mashonaland West', 'ZW-MW'),
(3491, 'ZW', 'Masvingo', 'ZW-MV'),
(3492, 'ZW', 'Matabeleland North', 'ZW-MN'),
(3493, 'ZW', 'Matabeleland South', 'ZW-MS'),
(3494, 'ZW', 'Midlands', 'ZW-MI');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `rv_region`
--
ALTER TABLE `rv_region`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `rv_region`
--
ALTER TABLE `rv_region`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3495;

